<#******************************************************************************
       FONCTIONS PERMETTANT DE QUITTER TOUTES LES INSTANCES DE LA TROUSSE
******************************************************************************#>
Function Exit-Script {
# Cette fonction est utiliser seulement lorsque la trousse se
#	termine avec un code de retour diffrents de '0' ou '1'	Param([String]$LastExitCode)
	Param([String]$LastExitCode)
	Exit $LastExitCode
}

<#******************************************************************************
                           DEMANDE CONFIRMATION                                
******************************************************************************#>
	If ($Prompt){
 		$rc=Show-Msgbox -message "Voulez-vous vraiment dsinstaller ce logiciel?" `
			-icon "question" -button "YesNo" -title "Dsinstallation de la trousse"
 		If (!($rc -eq "Yes")) {break}
 	}
	Set debut $true

<#******************************************************************************
                        DCLARATION DES VARIABLES                               
******************************************************************************#>
	$is64bitPowershell 	= [IntPtr]::Size -eq 8
	$guilmt				= [char]34
	$strNom_SCRIPT 		= $MyInvocation.MyCommand.Name
	$RepInstall 		= (split-path -parent ($MyInvocation.MyCommand).Path)
	$OSArchitecture     = (gwmi win32_computersystem).SystemType
	if ($OSArchitecture -eq "X86-based PC") {
      $OSArchitecture = "32 bits"}
	elseif ($OSArchitecture -eq "X64-based PC") {
      $OSArchitecture = "64 bits"}

<#******************************************************************************
                           PRPARATION DES LOGS                                
******************************************************************************#>
	$strRepLog 			= Check-Logs-Dir

<#******************************************************************************
                               VALIDATIONS                                     
******************************************************************************#>
	#----- VALIDATION SI Admin -----#
	Is-Admin

	Write-Log "G" "Dbut de la dsinstallation de la trousse $strNOM_TROUSSE"
	
	#----- VALIDATION SI LA TROUSSE EST DJ INSTALLE -----#
	If(!($force)){Check-if-is-installed "!$strNOM_TROUSSE" -Uninstall}
	
	Compare-OSarchi-ProgArchi
	$HardwareType = Get-Hardware-Type
	Write-Log "I" "Utilisateur : $env:USERNAME"