<#******************************************************************************
* **************************************************************************** *
* *                                                                          * *
* *   	.UTILISATION:                                                        * *
* *       	Ce fichier ne peut �tre lanc� seul. 							 * *
* *		  	Il est appel� par 'ScriptInstall' lors de son ex�cution		     * *
* *                                                                          * *
* *   	.EXECUTION DE LA TROUSSE :                                           * *
* *		  	powershell .\ScriptInstall -InstallDir 'C:\Program Files\Microsoft Office'
* *																			 * *
* *																			 * *
* *   	.DESCRIPTION :                                                       * *
* *       	Ce fichier contient toutes les op�rations d'installation         * *
* *       	permettant l'installation et la configuration de la trousse.     * *
* *                                                                          * *
* *	  	.AUTHEURS :                                                          * *
* *			NOM : Jacques Bouchard      DATE : 24 mars 2014		 	 	     * *
* *                                                                          * *
* *	  	.MODIFICATIONS :                                                     * *
* *			NOM : Mathieu Fairservice   DATE : 16 novembre 2015              * *
* *			DESCRITION :                                                     * *
* *			NOM :  Alain Murray    DATE :  2017-08-01                        * *
* *			DESCRIPTION : Suppression Windows XP et GRTC		             * *
* *																			 * *
* *		.VERSION :															 * *
* *			Gabarit V07						DATE : Novembre 2013			 * *
* *                                                                          * *
* **************************************************************************** *
******************************************************************************#>

<#******************************************************************************
#                   DETECTION SI UN RED�MARRAGE EST EN ATTENTE                 *
#                                                                              *
#  Aucun argument = Continue l'installation m�me si un reboot est en attente.  *
#                                                                              *
#  Ajouter l'argument -Abort lorsque le produit ne peut s'installer sans que   *
#  le poste ne soit pr�alablement red�marr�.                                   *
#                                                                              *
#    ex: Detecte-Redemarrage-Requis -Abort                                     *
#                                                                              *
#******************************************************************************#>
 
 Detecte-Redemarrage-Requis
 
#*******************************************************************************
#               DEFINITION DES VARIABLES ET DES CONSTANTES                     *
#*******************************************************************************


#*******************************************************************************
#                       VALIDATION DES PR�-REQUIS                              *
#*******************************************************************************
	#Si le commutateur -FORCE est employ� cette validation est skipp�.
	If(!($force)){Pre-Requis}

#*******************************************************************************
#                        OP�RATIONS D'INSTALLATION                             *
#*******************************************************************************

if ($architectureWindows -eq "64 bits") {
	$archWin = "x64"
	write-log "I" "Ajout d'information au registre pour l'enregistrement de l'ActiveX"
	CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
		-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\ActiveX_X64.reg`""

	CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
		-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\ModuleUsage_X64.reg`""	
} else {
	$archWin = "x86"
}

write-log "I" "Importation des informations de registre pour les Sites de confiance"
CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
	-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\TrustedSites_$archWin.reg`""

# Fortinet

#*******************************************************************************
# Ancienne installation
#*******************************************************************************

Write-log "I" "Resinstallation de l'ancien pilote FortiToken en ALLUSERS"

Start-Process "MSIexec.exe" -ArgumentList "/i `"$strREP_SCRIPT\Sources\FortiToken-FTK300-Minidriver-Setup_x64.msi`" ALLUSERS=1 /qn"	-Wait

Write-log "I" "Desinstallation de l'ancien pilote FortiToken en ALLUSERS"

Start-Process "MSIexec.exe" -ArgumentList "/x `"$strREP_SCRIPT\Sources\FortiToken-FTK300-Minidriver-Setup_x64.msi`" ALLUSERS=1 /qn"	-Wait

#*******************************************************************************
# Fin ancienne installation
#*******************************************************************************

Write-log "I" "Installation du nouveau pilote FortiToken en ALLUSERS"

Start-Process "MSIexec.exe" -ArgumentList "/i `"$strREP_SCRIPT\Sources\FortiToken-FTK300-Setup_x64.msi`" ALLUSERS=1 /qn" -Wait

# Fin Fortinet

#***************************************** Installation des pilotes Gemalto **************************************************************
Write-Host "Lancement de la vrification des pilotes Gemalto"
Start-Sleep 2
$Infs = Get-ChildItem $env:windir\inf | where { $_.Extension -eq ".inf"} | % { if((Get-Content $_.FullName) -like ("*Gemalto*")){ $_.Name }}
		
if($infs)
{
	foreach ($inf in $infs)
		{
			Write-Host "Supression des ancien Driver"
			Start-Sleep 1
				
			pnputil /delete-driver $Inf /force /Uninstall
            
            Start-Sleep 1
		}

	If(Test-Path $env:Windir\inf\Gemalto\SC){Remove-Item -Path "$env:Windir\inf\Gemalto\SC" -recurse -Force}
	If(Test-Path $env:Windir\inf\Gemalto\SCReader){Remove-Item -Path "$env:Windir\inf\Gemalto\SCReader" -recurse -Force}
	  
}

Write-Host "Lancement de la vrification des pilotes SafeNet"
Start-Sleep 2
$Infs2 = Get-ChildItem $env:windir\inf | where { $_.Extension -eq ".inf"} | % { if((Get-Content $_.FullName) -like ("*SafeNet*")){ $_.Name }}
		
if($infs2)
{
	foreach ($inf2 in $infs2)
		{
			Write-Host "Supression des ancien Driver"
			Start-Sleep 1
				
			pnputil /delete-driver $Inf2 /force /Uninstall
            
            Start-Sleep 1
		}
		
	If(Test-Path $env:Windir\inf\Gemalto\SC){Remove-Item -Path "$env:Windir\inf\Gemalto\SC" -recurse -Force}
	If(Test-Path $env:Windir\inf\Gemalto\SCReader){Remove-Item -Path "$env:Windir\inf\Gemalto\SCReader" -recurse -Force}
	  
}		
		

# Installation SafeNet


Write-log "I" "Installation du nouveau pilote SafeNet en ALLUSERS"

Start-Process "MSIexec.exe" -ArgumentList "/i `"$strREP_SCRIPT\Sources\SafeNet-Minidriver-x64-10.8-R9.msi`" ALLUSERS=1 /qn" -Wait

Write-log "I" "REMOVE=SACMonitor du nouveau pilote SafeNet en ALLUSERS"

Start-Process "MSIexec.exe" -ArgumentList "/i `"$strREP_SCRIPT\Sources\SafeNet-Minidriver-x64-10.8-R9.msi`" ALLUSERS=1 /qn REMOVE=SACMonitor" -Wait


# Fin Installation SafeNet


# Installation Hypersecu


Write-log "I" "Installation du nouveau pilote Hypersecu en ALLUSERS"

Start-Process "MSIexec.exe" -ArgumentList "/i `"$strREP_SCRIPT\Sources\HYP2003-RAMQ-Setup_x64.msi`" ALLUSERS=1 /qn" -Wait


# Fin Installation Hypersecu


If (Test-Path "$env:windir\temp\etoken*")
{
	Write-Log -Type Information -Text "Suppression du Etoken dans Windows temp" -NoEventLog -Verbose
	Remove-item "$env:windir\temp\etoken*" -recurse -force -ErrorAction SilentlyContinue
}

Install-IECompatibilitySiteList

# ************************* Configuration du registre selon la version de IE
switch($versionIE){

	"9.0."{
		write-log "I" "Configuration des Sites de confiance et Compatibility View pour IE9"
		CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
			-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\IE9_CompatibilityView_$archWin.reg`""				
	}
	
	"9.10"{
		write-log "I" "Configuration des Sites de confiance pour IE10"
		if ($archWin -eq "x86") {
			$pathExist = test-path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\ZoneMap\Domains\gouv.qc.ca"
			if(!($pathExist)){
				CMD-Exec -PathToExec "$env:Windir\system32\reg.exe" `
					-ParamToPush "IMPORT $strREP_SCRIPT\Sources\reg\IE10_SiteDeConfiance_$archWin.reg"
			} Else { Write-log "I" "Aucune modification n'est n�cessaire � votre syst�me"}
		} else {
			CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
				-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\IE10_SiteDeConfiance_$archWin.reg`""
		}
	}
	
	"9.11"{
		write-log "I" "Configuration des Sites de confiance pour IE11"
		
		if(($versionWindows -eq "Windows 8") -or ($versionWindows -eq "Windows 8.1") -or ($versionWindows -eq "Windows 2008")) {				
			CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
				-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\IE11_SiteDeConfiance_Win8.1_$archWin.reg`""
		} Else {				
			CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
				-ParamToPush "/c $env:Windir\system32\reg.exe IMPORT `"$strREP_SCRIPT\Sources\reg\IE11_SiteDeConfiance_$archWin.reg`""
		 }
	}
	default {write-log "I" "Votre version d'Internet Explorer ne n�cessite aucune modification"}
}


#***************************************************************************************************************************************

Write-Log "I" "Modification de la clef de registre : CardDisconnectPowerDownDelay"
if (Test-Path HKLM:\Software\Microsoft\Cryptography\calais) {
	Write-log "I" "Modification de la clef de registre : La valeur existe dj."
	$valeur =  Registry-operations -GetValue -LocalMachine -RegKey "Software\Microsoft\Cryptography\calais" -DWORD -RegValue "CardDisconnectPowerDownDelay"
	if ($valeur -lt 7200) {
	Write-log "I" "Modification de la clef de registre : La valeur est inf�rieur � 7200, augmentation � 7200"
	REG ADD "HKLM\SOFTWARE\Microsoft\Cryptography\Calais" /v CardDisconnectPowerDownDelay /t REG_DWORD /d 7200 /f
	}
} else  {
	Write-log "I" "Modification de la clef de registre : La valeur n'existe pas. Inscription de 7200"
	REG ADD "HKLM\SOFTWARE\Microsoft\Cryptography\Calais" /v CardDisconnectPowerDownDelay /t REG_DWORD /d 7200 /f
}


Write-Log "I" "Modification de la clef de registre : TransactionTimeoutDelay"
if (Test-Path HKLM:\Software\Microsoft\Cryptography\calais) {
	Write-log "I" "Modification de la clef de registre : La valeur existe dj."
	$valeur =  Registry-operations -GetValue -LocalMachine -RegKey "Software\Microsoft\Cryptography\calais" -DWORD -RegValue "TransactionTimeoutDelay"
	if ($valeur -lt 60) {
	Write-log "I" "Modification de la clef de registre : La valeur est inf�rieur � 60, augmentation � 60"
	REG ADD "HKLM\SOFTWARE\Microsoft\Cryptography\Calais" /v TransactionTimeoutDelay /t REG_DWORD /d 60 /f
	}
} else  {
	Write-log "I" "Modification de la clef de registre : La valeur n'existe pas. Inscription de 60"
	REG ADD "HKLM\SOFTWARE\Microsoft\Cryptography\Calais" /v TransactionTimeoutDelay /t REG_DWORD /d 60 /f
}


#***********************************************************************
# Modification des cl de registre Calais
#**********************************************************************
Write-Host "Application des permissions sur la cl Calais en cours..."
Write-Log "I" "Application des permissions sur la cl Calais"
$registryPath = "HKLM:\Software\Microsoft\Cryptography\Calais"

if (Test-Path $registryPath) {
    try {
        $acl = Get-Acl -Path $registryPath
        $rule = New-Object System.Security.AccessControl.RegistryAccessRule(
            "NT AUTHORITY\LOCAL SERVICE",
            "FullControl",
            "ContainerInherit,ObjectInherit",
            "None",
            "Allow"
        )
        $acl.SetAccessRule($rule)
        Set-Acl -Path $registryPath -AclObject $acl
        Write-Log "I" "Permissions appliques correctement  $registryPath"		
        Write-Host "Permissions appliques correctement  $registryPath"
    } catch {
        Write-Log "E" "Erreur lors de l'application des permissions : $_"	
        Write-Host "Erreur lors de l'application des permissions : $_"
    }
} else {
    Write-Log "W" "La clé du registre n'existe pas : $registryPath"	
    Write-Host "La clé du registre n'existe pas : $registryPath"
}


Write-Log "I" "Modification de la clef de registre : BlockBackgroundWindowActivationInIEMode"
if (Test-Path "HKLM:\Software\Microsoft\Internet Explorer\Main\EnterpriseMode") {
	Write-log "I" "Modification de la clef de registre : La valeur existe dj."
	$valeur =  Registry-operations -GetValue -LocalMachine -RegKey "Software\Microsoft\Internet Explorer\Main\EnterpriseMode" -DWORD -RegValue "BlockBackgroundWindowActivationInIEMode"
	if ($valeur -lt 0) {
	Write-log "I" "Modification de la clef de registre : La valeur doit �tre � 0"
	REG ADD "HKLM\SOFTWARE\Microsoft\Internet Explorer\Main\EnterpriseMode" /v BlockBackgroundWindowActivationInIEMode /t REG_DWORD /d 0 /f
	}
} else  {
	Write-log "I" "Modification de la clef de registre : La valeur n'existe pas. Inscription de 0"
	REG ADD "HKLM\SOFTWARE\Microsoft\Internet Explorer\Main\EnterpriseMode" /v BlockBackgroundWindowActivationInIEMode /t REG_DWORD /d 0 /f
}	
	
#***************************************** Installation des certificats *************************************************************
write-log "I" "Copie locale des certificats"
Copy-Files -SourceToCopy "$strREP_SCRIPT\Sources\Certificats" -FileToCopy "*" -CopyDestination "C:\TempCertificats" -ForceCopy

write-log "I" "Lecture des noms de fichiers"
$certificateName = get-childitem "C:\TempCertificats\*.cer" -Name

Write-log "I" "Ajouts des certificats"
foreach($cert in $certificateName) {		
	if(!($cert -like "*racine*")) {
		Write-log "I" "Ajout du certificat $cert dans CA"
		CMD-Exec -PathToExec "$env:Windir\system32\certutil.exe" `
			-ParamToPush " -addstore -f ""CA"" C:\TempCertificats\$cert"
	} Else {
		Write-log "I" "Ajout du certificat $cert dans ROOT"
		CMD-Exec -PathToExec "$env:Windir\system32\certutil.exe" `
			-ParamToPush " -addstore -f ""root"" C:\TempCertificats\$cert"
	}
} 

Write-log "I" "Suppression du r�pertoire temporaire"
Delete-File-Folder -RepToDelete "C:\TempCertificats" -FilesToDelete "*" -Recursive

#********************************************* Copie du fichier ic�ne *****************************************************************
write-log "I" "Copie du fichier ic�ne dans le r�pertoire $env:Windir\System32"
Copy-Files -SourceToCopy "$strREP_SCRIPT\Sources" -FileToCopy "LogoDSQ.ico" -CopyDestination "$env:Windir\System32" -ForceCopy
 
#***************************************** Copie des fichier de l'activeX *************************************************************
$pathInstallActiveX = "$env:Windir\Downloaded Program Files"
Write-log "I" "Copie des fichiers n�cessaires � l'installation du visualiseur"
Copy-Files -SourceToCopy "$strREP_SCRIPT\Sources\ActiveX" -FileToCopy "*" -CopyDestination "$pathInstallActiveX" -ForceCopy

#********************************************** Installation de l'activeX *************************************************************
Write-log "I" "Installation de l'ActiveX du visualiseur"
if(test-path "$pathInstallActiveX\CryptoHelper.inf"){
	CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
		-ParamToPush "/c RUNDLL32.EXE SETUPAPI.DLL,InstallHinfSection DefaultInstall 132 $pathInstallActiveX\CryptoHelper.inf" #	 -ManageRC
} Else{ Write-log "W" "Le chemin d'acc�s � CryptoHelper.inf n'existe pas"}
		
#********************************************** Enregistrement du .dll ****************************************************************
Write-log "I" "Enregistrement des extensions .dll du visualiseur"
if(test-path "$pathInstallActiveX\CryptoHelperATL.dll"){
	CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
		-ParamToPush "/c regsvr32 ""$pathInstallActiveX\CryptoHelperATL.dll"" /s"
} Else { Write-log "W" "Le chemin d'acc�s � CryptoHelperATL.dll n'existe pas"}

write-log "I" "Copie des raccourcis du bureau"
Copy-Files -SourceToCopy "$strREP_SCRIPT\Sources\Raccourcis" -FileToCopy "*" -CopyDestination "$AllUserDesktop" -ForceCopy
