<#******************************************************************************
* **************************************************************************** *
* *                                                                          * *
* *		.DESCRIPTION :                                                       * *
* *			Ce script est le module principale de l'installation de la       * *
* *			 trousse. C'est  partir de lui que sont inclus l'ensemble des   * *
* *			 autres PS1.                                                     * *
* *                                                                          * *
* *		.UTILISATION:                                                        * *
* *			Vous ne pouvez modifier ce script afin de faire l'installation   * *
* *				de votre logiciel. Ce script doit rester tel quel car il     * *
* *				car il prpare l'installation de votre logiciel en fonction  * *
* *             des routines que vous appeles dans le script 'install.ps1   * *
* *				et 'EndUnstall.ps1'                                          * *
* *                                                                          * *
* *			Ce fichier ne peut tre lanc seul. Il est appel par            * *
* *				'ScriptInstall.ps1' lors de son excution.                   * *
* *                                                                          * *
* *		.SWITCH DISPONIBLE													 * *
* *			$Force		: Switch On/Off permettant de forcer l'installation  * *
* *							de la trousse et ce malgr la validation des     * * 
* *							pr-requis. Tel que :                            * * 
* *							 Est-ce que cette trousse est dj installe ?   * *
* *							 Est-ce qu'une autre trousse doit tre installe ? *
* *			$Help		: Switch On/Off permettant d'afficher un fichier     * *
* *							d'aide de la trousse                             * * 
* *			$Verbose	: Switch On/Off permettant d'afficher les commentaire* * 
* *							inscrit dans les logs d'installation             * *
* *			$Fonctions	: Switch On/Off permettant d'afficher les fonctions  * *
* *							disponible dans le script d'installation         * * 
* *							'.include\lib.ps1' de la trousse                 * *
* *                                                                          * *
* *		EXECUTION DE LA TROUSSE :                                            * *
* *		powershell .\ScriptInstall.ps1										 * *
* *                                                                          * *
* *		.AUTEURS :                                                           * *
* *			NOM : Dany Fournier        DATE : Fvrier 2011                   * *
* *			NOM : Simon Noiseux        DATE : Mars & Avril 2011              * *
* *                                                                          * *
* *		.MODIFICATIONS :                                                     * *
* *			NOM :  Alain Murray    DATE :  2017-08-01                        * *
* *			DESCRIPTION : Suppression Windows XP et GRTC		             * *
* *				...                                                          * *
* *																			 * *
* *		.VERSION :															 * *
* *			Gabarit V07						DATE : Novembre 2013			 * *
* *                                                                          * *
* **************************************************************************** *
******************************************************************************#>


<#******************************************************************************
							CAPTURE DES PARAMTRES
	Notez que chacun des paramres saisis ici doivent tre documenter dans le
	fichier d'excution des arguments du script d'encadrement :
		'.\include\Args.ps1'
******************************************************************************#>
param( 
    [Switch] $Force,
    [Switch] $Help,
    [String] $InstallParam,
	[Switch] $Verbose,
    [Switch] $Fonctions,
	[String] $Install,
	[String] $Config
)
	#Exemples
	#	[String] $P1
	#	[String] $P2 = "default"
	#	[String] $user,
	#	[String] $pwd,

<#******************************************************************************
                 PRPARATION DES VARIABLES D'ENVIRONNEMENTS
******************************************************************************#>
Set debut $true

<#******************************************************************************
                     Dfinition des variables du gabarit
******************************************************************************#>
$guilmt				= [char]34
$is64bitPowershell 	= [IntPtr]::Size -eq 8
$proc = get-wmiobject win32_processor | where {$_.deviceID -eq "CPU0"}
If ($proc.addresswidth -eq '64'){$OSArchitecture = '64 Bits'}
ElseIf ($proc.addresswidth -eq '32'){$OSArchitecture = '32 Bits'}
$strNom_SCRIPT 		= $MyInvocation.MyCommand.Name
$strREP_SCRIPT 		= (split-path -parent ($MyInvocation.MyCommand).Path)
$strComputerName    = (Get-WmiObject Win32_ComputerSystem).name
$strDOMAIN		    = (Get-WmiObject Win32_ComputerSystem).domain



#*******************************************************************************
#                  FONCTIONS SPCIFIQUES  CETTE TROUSSE                       *
#*******************************************************************************

Function getWindowsVersion{
$osVersion = [System.Environment]::OsVersion.Version
	switch($osVersion.Major) {
        6{
            switch ($osVersion.Minor) {
                0{
					write-host "L'installation de la trousse du visualiseur n'est pas supporte sous Windows Vista"
					break;}
				1{
                    switch ($osVersion.Build) {
                        7600{return "Windows 7"}									
						7601{
							[string]$osVer = wmic os get caption
							if($osVer.Contains("7")){
								$osVersion = "Windows 7 SP1"
								return $osVersion
							}Else{
								if($osVer.Contains("2008")){
								$osVersion = "Windows 2008"
								return $osVersion}
							 }  # Fin if - else
						}
                        default{return "Impossible de dterminer la version de Windows"}
                     }
				}
                2{
                    switch ($osVersion.Build) {
                        9200{return "Windows 8"}
                        default{return "Impossible de dterminer la version de Windows"}
                    }						
				}
				3{
                    switch ($osVersion.Build) {
                        9600{return "Windows 8.1"}
                        default{return "Impossible de dterminer la version de Windows"}
                    }						
				}
                default{return "Impossible de dterminer la version de Windows"}
            }
		}
		10{
			switch ($osVersion.Minor) {
                0{
						$osVersion = "Windows 10"
								return $osVersion
				}
			}				
		}
        default{return "Impossible de dterminer la version de Windows"}
	}	
	return $osVersion
}
#***************************************************************************************************************************************

Function getWindowsArchi{
	$WinArchi = get-wmiobject win32_processor | where {$_.deviceID -eq "CPU0"}
	If ($WinArchi.addresswidth -eq '64'){
		return $OSArchitecture = '64 Bits'
	}ElseIf ($WinArchi.addresswidth -eq '32'){
		return $OSArchitecture = '32 Bits'
	 }		 
}
#***************************************************************************************************************************************

Function getIEVersion{
	if(test-path ($path = 'HKLM:\SOFTWARE\Microsoft\Internet explorer\')){
		$valeur = Get-ItemProperty $path | Select-Object -ExpandProperty "version"
		return $valeur.substring(0,4)
	}Else{write-log "W" "La version d'Internet Explorer ne peut tre dtermine"}
}
#***************************************************************************************************************************************

	$versionWindows =  getWindowsVersion
	$architectureWindows = getWindowsArchi
	$versionIE = getIEVersion
	$OsLanguage = (Get-WmiObject Win32_OperatingSystem).OSLanguage
	$DefaultProgramsDir = "$env:ProgramFiles"

#***************************************************************************************************************************************
	
<#******************************************************************************
               INCLUSION DES VARIABLES DU GABARIT (dot-sourcing)
******************************************************************************#>
	. "$strREP_SCRIPT\include\Lib.ps1"		#Dfinition des fonctions
	. "$strREP_SCRIPT\include\IEIntegration.ps1"		#Dfinition des fonctions

<#******************************************************************************
       FONCTIONS PERMETTANT DE QUITTER TOUTES LES INSTANCES DE LA TROUSSE
******************************************************************************#>
Function Exit-Script {
# Cette fonction est utiliser seulement lorsque la trousse se
#	termine avec un code de retour diffrents de '0' ou '1'	Param([String]$LastExitCode)
	Param([String]$LastExitCode)
	Exit $LastExitCode
}
<#******************************************************************************
                           VALIDATION SI Admin
******************************************************************************#>
	Is-Admin

<#******************************************************************************
                Dfinition des variables de la trousse (dot-sourcing)
******************************************************************************#>
	. "$strREP_SCRIPT\include\Variables.ps1"	#Dfiniton des variables de la trousse
	. "$strREP_SCRIPT\include\Constantes.ps1"	#Dfiniton des variables du gabarit

<#******************************************************************************
                          PRPARATION DES LOGS
******************************************************************************#>
	# L'emplacement des logs diffrent en fonction du client cibl par la trousse
	#	- un serveur = D:\Logs
	#	- un poste   = C:\Programmes Files\DSQ\Logs
	$strRepLog = Check-Logs-Dir

<#******************************************************************************
 Validation de la prsence des commutateurs d'instalaltion et de configuration
 Si aucun n'est spcifi alors la trousse n'est pas excute
******************************************************************************#>
If (($Install -like $null) -and ($Config -like $null)) {Write-log "E" "Vous devez spcifier un commutateur d'installation ou de configuration" "7020"}


Write-Log "G" "Dbut de l'installation de la trousse $strNOM_TROUSSE"

Compare-OSarchi-ProgArchi

<#******************************************************************************
                    	AJOUT DES ARGUMENTS AU LOG
******************************************************************************#>
	. "$strREP_SCRIPT\include\Args.ps1"		#Dfinition des arguments
	Write-Log "I" "Liste des arguments"
	ForEach($arg in $Argments ) {Write-Log "I" "  ->$arg"}

	Write-Log "I" "Utilisateur : $env:USERNAME"
<#******************************************************************************
                  INSTRUCTION D'INSTALLATION DE LA TROUSSE
******************************************************************************#>
	# Ce compteur est utilis pour viter de rpter de faon conscutive le mme message 
	#	lorsque cette fonction est utilise dans une boucle
	$Global:Compteur=0
	
	
	# Si le commutateur d'installation est utilis : excution du script '.\include\install.ps1'
	If ($Install -notlike $null){
	# Si la Switch 'Force' est utilis cette routine est passe
		If (!$Force){Check-If-is-installed -Program "!$strNOM_TROUSSE"}
		. "$strREP_SCRIPT\Include\Install.ps1"}
		
	if($do_exit) {Exit-Script}
	# Si le commutateur de configuration est utilis : excution du script '.\include\config.ps1'
	If ($Config -notlike $null) {
		If (!$Install){Check-If-is-installed -Program "!$strNOM_TROUSSE" -Requis}
		. "$strREP_SCRIPT\Include\Config.ps1"}

	# La variable 'do_exit' peut-tre utilis pour terminer la routine d'installation 
	#	du client, advenant le cas o une erreur majeure se produit lors de l'excution
	#	du script '.\include\install.ps1'
	 if($do_exit) {Exit-Script}

	$Global:Compteur=0

<#******************************************************************************
                       CRATION DE L'ACTIVE SETUP
******************************************************************************#>
	# Validation de la prsence du rpertoire 'Active_Setup' sous le rpertoire
	#	'.\Autres' de la trousse
	If (Test-Path "$RepSrcActiveSetup"){
		# Validation du contenu du rpertoire 'Active_Setup'
		If (Get-ChildItem "$RepSrcActiveSetup") {
			Write-Log "I" "Configuration ncessaire pour l'Active Setup de la trousse"
			ForEach-Object {Get-ChildItem "$RepSrcActiveSetup"} | Where-Object {
				$i = $i + 1
				Copy-Files -SourceToCopy $_.DirectoryName -FileToCopy $_ `
					-CopyDestination "$DefaultProgramsDir$RepDestCfgFiles" -ForceCopy
				If ($_ -ne $null){
					# La procdure de cration de l'entr de registre Active Setup
					#	diffre selon le type de fichier fichiers prsents dans le rpertoire 'Active_Setup'
					Write-Log "I" " --> Inscription de l'Active Setup dans le Registre"
					If (($_.extension -eq ".cmd") -or ($_.extension -eq ".bat")){
						Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
							-CMDtoExec "cmd.exe /c $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
							-VersionTrousse $strNOM_TROUSSE_VERSION
					}
					Elseif ($_.extension -eq ".ps1"){
						Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
							-CMDtoExec "C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe -file $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
							-VersionTrousse $strNOM_TROUSSE_VERSION
					}
					Elseif ($_.extension -eq ".vbs"){
						Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
							-CMDtoExec "cscript.exe $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
							-VersionTrousse $strNOM_TROUSSE_VERSION
					}
					ElseIf ($_.extension -eq ".reg"){
						Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
							-CMDtoExec "reg.exe import $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
							-VersionTrousse $strNOM_TROUSSE_VERSION
					}
				}
			}
		}
	}

	$Global:Compteur=0


<#******************************************************************************
                 CRATION DU FICHIER DE DSINSTALLATION
******************************************************************************#>
	Write-Log "I" "Prparation du fichier Uninstall.ps1"
	
	# NOTE: La variable '$DefaultProgramsDir$RepDestCfgFiles' DOIT tre dfinit dans le fichier 'config.ps1'
	If (Test-Path "$DefaultProgramsDir$RepDestCfgFiles\UnInstall.ps1"){Remove-Item "$DefaultProgramsDir$RepDestCfgFiles\UnInstall.ps1" | Out-Null}

	#-----------Prparation de la liste des arguments------------
	# Ces arguments seront ajouts au dbut du script de dsinstallation de la trousse 'Uninstall.ps1'
	$ValueCon = 'param([Switch] $force,[Switch] $Prompt,[Switch] $Verbose)'
	If (Test-Path "$env:Temp\var.txt"){Remove-Item "$env:Temp\var.txt" | Out-Null}	
	Add-Content -Path "$env:Temp\var.txt" -Value ("$ValueCon")

	Apend-File-In-File "$env:Temp\var.txt" "$DefaultProgramsDir$RepDestCfgFiles" "UnInstall.ps1"

	#-----------Prparation de la variable $strNOM_TROUSSE------------
	# Cette variable est ajoute au dbut du script de dsinstallation de la trousse 'Uninstall.ps1'
	$ValueCon = '$strNOM_TROUSSE = ' + '"'+$strNOM_TROUSSE+'"'
	If (Test-Path "$env:Temp\var.txt"){Remove-Item "$env:Temp\var.txt" | Out-Null}	
	Add-Content -Path "$env:Temp\var.txt" -Value ("$ValueCon")

	Apend-File-In-File "$env:Temp\var.txt" "$DefaultProgramsDir$RepDestCfgFiles" "UnInstall.ps1"

	#-----------Prparation de la variable $strREP_SCRIPT------------
	# Cette variable est ajoute au dbut du script de dsinstallation de la trousse 'Uninstall.ps1'
	$ValueCon = '$strREP_SCRIPT 		= (split-path -parent ($MyInvocation.MyCommand).Path)'
	If (Test-Path "$env:Temp\var.txt"){Remove-Item "$env:Temp\var.txt" | Out-Null}	
	Add-Content -Path "$env:Temp\var.txt" -Value ("$ValueCon")



	Apend-File-In-File -FileRead "$env:Temp\var.txt" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"

	#-----------Inclusion des fichiers PS1 de la trousse------------
	Apend-File-In-File -FileRead "$strREP_SCRIPT\Include\Constantes.ps1" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"
	Apend-File-In-File -FileRead "$strREP_SCRIPT\Include\Variables.ps1" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"
	Apend-File-In-File -FileRead "$strREP_SCRIPT\Include\Lib.ps1" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"
	Apend-File-In-File -FileRead "$strREP_SCRIPT\Include\PreUninstall.ps1" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"
	Apend-File-In-File -FileRead "$strREP_SCRIPT\Include\Uninstall.ps1" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"
	Apend-File-In-File -FileRead "$strREP_SCRIPT\Include\PostUninstall.ps1" -Dest "$DefaultProgramsDir$RepDestCfgFiles" -File "UnInstall.ps1"

	$Global:Compteur=0


<#******************************************************************************
                  CRATION DE L'EMPREINTE DE LA TROUSSE
******************************************************************************#>
	Write-Log "I" "Cration de l'empreinte de la trousse."
	
	$UninstallString = "$env:windir\System32\WindowsPowerShell\v1.0\Powershell.exe -file ""$env:ProgramFiles\$RepDestCfgFiles\Uninstall.ps1"" -Prompt"
	
	$datelong = Get-Date -format yyyy/MM/dd
	$dateReg = $datelong+"-$time"

	# Inscription de la trousse dans la bae de registre
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "DisplayName" `
		-NewRegValueProperties "!$strNOM_TROUSSE" -String
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "DisplayVersion" `
		-NewRegValueProperties "$strVersionTrousse" -String
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "SystemComponent" `
		-NewRegValueProperties 0 -DWORD
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "UninstallString" `
		-NewRegValueProperties "$UninstallString" -String
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "Publisher" `
		-NewRegValueProperties "DSQ" -String
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "NoModIfy" `
		-NewRegValueProperties 1 -DWORD
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "NoRepair" `
		-NewRegValueProperties 1 -DWORD
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "DisplayIcon" `
		-NewRegValueProperties "$env:windir\System32\WindowsPowerShell\v1.0\Powershell.exe" -String
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath!$strNOM_TROUSSE" -RegValue "InstallDate" `
		-NewRegValueProperties "$dateReg" -String
	

	$Global:Compteur=0
	
#*****Masque de l'entr prsent l'lment "Ajout Suppression de programmes"*****
#******** prsent dans le panneau de configuration                         *****
	ForEach ($item in $DefaultRegEntry){Hide-Soft-Ctrl-Panel -Logiciel	$item}
	
	
	if(test-path "C:\DSQ\ParamTrousses\$strNOM_TROUSSE\UnInstall.ps1"){
		write-log "I" "Dplacement des des fichiers de dsinstallation pour les postes XP"	
		Copy-Files -SourceToCopy "C:\DSQ\ParamTrousses\$strNOM_TROUSSE" -FileToCopy "*" -CopyDestination "$env:ProgramFiles\$RepDestCfgFiles" -ForceCopy
		write-log "I" "Suppression du rpertoire temporaire C:\DSQ pour les postes XP"
		Delete-File-Folder -RepToDelete "C:\DSQ" `
			-FilesToDelete "*" -Recursive
	}

#***** Demande  l'utilisateur de redmarrer le poste *****	
	
	write-log "W" "Le poste doit tre redmarr pour que le visualiseur fonctionne correctement"
	write-log "W" "Si un processus empche le redmarrage, il est prfrable de redmarrer le poste manuellement"
	$rebootYesNo = "n"
	while($rebootYesNo -ne "o" -or $rebootYesNo -ne "n"){
		$rebootYesNo = read-host "Voulez-vous redmarrer immdiatement? O/N"
		if($rebootYesNo -eq "o"){
			Write-Log "G" "Installation de $strNOM_TROUSSE complt"
			If($versionWindows -eq "Windows XP"){
				restart-computer -force
				break
			}Else {
				restart-computer
				break
			 }
		}Elseif($rebootYesNo -eq "n"){
			Write-Log "G" "Installation de $strNOM_TROUSSE complt"
			If ($WarningExitCode){Exit $WarningExitCode}
			Else {Exit 0}
		}
	 }

