<#******************************************************************************
* **************************************************************************** *
* *                                                                          * *
* *   	.UTILISATION:                                                        * *
* *       	Ce fichier permet d'effectuer la d�sinstallation de la trousse.  * *
* *                                                                          * *
* *   	.DESCRIPTION :                                                       * *
* *       	Ce fichier sert lors de la g�n�ration du fichier uninstall.ps1   * *
* *       	qui sera d�pos� localement lors de l'installation de la trousse. * *
* *                                                                          * *
* *	  	.AUTHEURS :                                                          * *
* *			NOM : Jacques Bouchard      DATE : 3 mars 2014		 	 	     * *
* *                                                                          * *
* *	  	.MODIFICATIONS :                                                     * *
* *			NOM : Mathieu Fairservice   DATE : 16 novembre 2015              * *
* *			DESCRIPTION :                                                     * *
* *			NOM :  Alain Murray    DATE :  2017-08-01                        * *
* *			DESCRIPTION : Suppression Windows XP et GRTC		             * *
* *																			 * *
* *		.VERSION :															 * *
* *			Gabarit V07						DATE : Novembre 2013			 * *
* *                                                                          * *
* **************************************************************************** *
******************************************************************************#>

$linksToDelete = "Portail libre-service.rdp","DSQ Production.lnk","DSQ Formation.lnk"
$pathInstallActiveX = "$env:Windir\Downloaded Program Files"
$filesToDelete = "atl80.dll","crypt32.dll","CryptoHelper.inf","CryptoHelperATL.dll","mfc80.dll","Microsoft.VC80.ATL.manifest","Microsoft.VC80.CRT.manifest","Microsoft.VC80.MFC.manifest","msvcm80.dll","msvcr80.dll"

#*******************************************************************************
#         				FONCTIONS SP�CIFIQUES A CETTE TROUSSE  		           *
#*******************************************************************************


#*******************************************************************************
#         FONCTIONS DE D�SINSTALLATION SP�CIFIQUES A CETTE TROUSSE             *
#*******************************************************************************

Write-log "I" "Suppression des raccourcis"
foreach($link in $linksToDelete){
	Delete-File-Folder -RepToDelete "$AllUserDesktop" -FilesToDelete "$link"
}
 
# *****  D�senregistrement du fichier .dll  *****
If (Test-Path "$pathInstallActiveX\CryptoHelperATL.dll") {
	Write-log "I" "D�senregistrement des extensions .dll du visualiseur"
	CMD-Exec -PathToExec "$env:Windir\system32\cmd.exe" `
		-ParamToPush "/c regsvr32 ""$pathInstallActiveX\CryptoHelperATL.dll"" /u /s"
}

# *****  Suppression des fichier de l'ActiveX  ***** 
 Write-log "I" "Suppression des fichiers de l'ActiveX"
foreach($file in $filesToDelete){
	Delete-File-Folder -RepToDelete "$pathInstallActiveX" -FilesToDelete "$file"
}

Write-log "I" "Suppression des pilotes" 
Delete-File-Folder -RepToDelete "$env:Windir\inf\Gemalto\SCReader"	-FilesToDelete "*" -Recursive
Delete-File-Folder -RepToDelete "$env:Windir\inf\Gemalto\SC"	-FilesToDelete "*" -Recursive
Delete-File-Folder -RepToDelete "$env:Windir\inf\Gemalto"	-FilesToDelete "*" -Recursive
Start-Process "MSIexec.exe" -ArgumentList "/x {25A82868-7D7F-4816-BC8C-EFA2894B1AE0} ALLUSERS=1 /qn"  -Wait

# *****  Suppression de l'ic�ne  ***** 
Delete-File-Folder -RepToDelete "$env:Windir\system32"	-FilesToDelete "LogoDSQ.ico"