<#******************************************************************************
* **************************************************************************** *
* *                                                                          * *
* *		.DESCRIPTION :                                                       * *
* *			Ce script est une librairie de fonctions communes disponibles    * *
* *			lors de l'excution du fichier principal                         * *
* *                                                                          * *
* *		.UTILISATION:                                                        * *
* *			Vous ne pouvez modifier ce script afin de faire l'installation   * *
* *			de votre logiciel. Ce script doit rester tel quel car il    	 * *
* *			prpare l'installation de votre logiciel en fonction des 		 * *
* *			routines que vous appeles dans le script 'Install.ps1 et 		 * *
* *			'EndUnIstall.ps1'                                          	 	 * *
* *                                                                          * *
* *			Ce fichier ne peut tre lanc seul. Il est appel par            * *
* *			'ScriptInstall' lors de son excution.                  		 * *
* *                                                                          * *
* *		.EXECUTION DE LA TROUSSE :                                           * *
* *			powershell .\ScriptInstall -InstallDir 'C:\Program Files\Microsoft Office'
* *                                                                          * *
* *		.AUTHEURS :                                                          * *
* *			NOM : Dany Fournier        		DATE : Fvrier 2011              * *
* *			NOM : Simon Noiseux        		DATE : Mars & Avril 2011         * *
* *			NOM : Marc-Andr Robitaille   	DATE : volution				 * *
* *         NOM : Mathieu Fairservice		DATE : Septembre 2012			 * *
* *         NOM : Mathieu Fairservice		DATE : Fvrier 2013				 * *
* *         NOM : Mathieu Fairservice		DATE : Septembre 2013			 * *
* *                                                                          * *
* *		.VERSION :															 * *
* *			Gabarit V07						DATE : Novembre 2013			 * *
* *                                                                          * *
* **************************************************************************** *
******************************************************************************#>


Function Check-If-is-installed {
<#******************************************************************************  
	.DESCRIPTION  
    	Valide si la trousse est dj installe
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
		Mais elle est galement appele par .\ScriptInstall
	.SWITCH DISPONIBLE
		-Program		: Programme  rechercher (Obligatoire)
							Le nom du programme  rechercher doit tre inscrit entre des guillemets (' " ')
							L'utilisation de 'wildcars' est permise. Donc, si vous voulez rechercher toutes les 
								version d'une trousse vous pouvez inscrire 'Template_GENIAL_V*'
		-Requis			: Switch On/Off qui indique si le programme spcifi est un pr requis de cette trousse
							Si le programme n'est pas trouv la trousse se termine avec 
								le code de retour 7020
		-PresentOuiNon	: Switch On/Off qui retourne la prsence ou non du programme demand
							Une fois retourn, vous pouvez crer une condition dans votre
								script d'installation
		-Uninstall		: Switch On/Off qui valide si le logiciel est prsent AVANT
							de procder  la dsinstallation de la trousse (Obligatoire)
							Cette switch est appele par le script '.\include\TopUninstall.ps1'
		-Exception		: Switch On/Off qui valide la possibilit d'installer la trousse sur le poste (Obligatoire)
							Cette switch est appele par le script '.\ScriptInstall'
							Si le poste est identifi comme un exception dans la base de registre (UNINSTALL Path)
								la trousse ne sera pas install sur le poste / serveur
	.EXEMPLE
		Check-If-is-installed -Program "Template_GENIAL_V01"
	.NOTES  
		Auteur:    Dany Fournier & Simon Noiseux
******************************************************************************#>  
	Param(
		[String]$Program,
		[Switch]$Requis,
		[Switch]$Exception,
		[Switch]$PresentOuiNon,
		[Switch]$Uninstall
	)
			$error.clear()
	$ProgramFound = $false
	Write-Log -Type "I" -Msg "Validation de la prsence du logiciel $Program."

	# Cration de la liste des logiciels installs sur le client
	<# Si la liste des logiciels installs  dj t cre. Cette vrification ne se rexcutera pas
	If (!($ProgramList -ne $null)){
		$Global:ProgramList = Registry-Operations -GetValues -LocalMachine -RegKey "$WindowsRegistry$UninstallPathUni" -RegValue "Displayname" -STRING
		If ($OSArchitecture -eq "64 bits") {
			$ProgramListw3264 = Registry-Operations -GetValues -LocalMachine -RegKey "$WindowsRegistryW6432node$UninstallPathUni" -RegValue "Displayname" -STRING
			$Global:ProgramList = $ProgramList+$ProgramListw3264
		}
	}
	# variable qui identifie si le programme a t trouv
	$ProgramFound = $false #> 
	
	#Vrification de la prsence de la trousse 
 
   $value64 = ""
    $value64 = get-childitem HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall | select name | where {$_.name -match $Program}
    If ($OSArchitecture -eq "64 bits") {
        $value32 = ""
        $value32 = get-childitem HKLM:\Software\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall | select name | where {$_.name -match $Program}
    }  
 
	if(($value32) -or ($value64)) {
        $ProgramFound = $true
    }

	
	# Utilisation de la switch On/Off 'Exception'
	If ($Exception){Write-Log -Type "E" -Msg "RC:7017 - Vous ne pouvez pas installer automatiquement cette trousse sur ce poste. Vous devez l'installer manuellement." "7017"}
	If ($PresentOuiNon -and $ProgramFound) {
			Write-Log -Type "I" -Msg "  --> La trousse recherche est installe."	
			Return $ProgramFound
		}
        ElseIf ($PresentOuiNon -and !$ProgramFound) {
        			Write-Log -Type "I" -Msg "  --> La trousse recherche n'est pas installe."	
					Return $ProgramFound
				} 
          
	If ($ProgramFound){
	
		If($Requis){Write-Log -Type "I" -Msg "  --> La trousse requise est installe."}
		ElseIf($Uninstall){Write-Log -Type "I" -Msg "  --> La trousse  dsinstaller est prsente."}
		Else{Write-Log -Type "E" -Msg "RC:7016 - Cette trousse est dj installe." "7016"}
	}
	Else{
		Write-Log -Type "I" -Msg "  --> La trousse recherche n'est pas installe."
		If ($Requis){Write-Log -Type "E" -Msg "RC:7015 - La trousse $Program doit tre installe auparavant." "7015"}
	}
	If ($error) {Write-Host $error}
}

Function Create-Folder {  
<#******************************************************************************  
	.DESCRIPTION
		Cette fonction cre un dossier
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
		Mais elle est galement appele par .\ScriptInstall
	.SWITCH DISPONIBLE
		-Path	:	Spcifie l'emplacement du rpertoire a crer
						Le rpertoire  crer doit tre inscrit entre des guillemets (' " ')
						Il n'est pas ncessaire d'inscrire le dernier backslash ('\') du chemin demand
	.EXEMPLE
		Create-Folder -Path "C:\Temp"
	.NOTES
		Auteur 	:	Dany Fournier  
******************************************************************************#> 
	Param(
		[String]$Path
	)
	$error.clear()
	$erroractionpreference  = "SilentlyContinue"
	#----- Prparation du fichier de journalisation. Si le rpertoire n'existe pas, on le cre
	If (!(Test-Path $Path))
	{New-Item -Path $Path -itemtype directory | Out-Null}

	If ($error) {
		$message1 = "$error | "
		$TargetPath = $error|%{$_.CategoryInfo.TargetName}
		$message = $message1+$TargetPath
		If (!$debut) {Write-Log -Type "E" -Msg "RC:7040 - $message" "7040"}
	}
	ElseIf (!$debut){Write-Log -Type "I" -Msg "La cration du dossier $Path s'est effectue avec succs"}
}


Function Write-Log {  
<#******************************************************************************  
	.DESCRIPTION
		Permet d'crire dans les dIffrents logs une information
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
		Mais elle est galement appele par .\ScriptInstall
	.SWITCH DISPONIBLE
		-Type	:	Spcifie le type de message a utiliser. 'G|I|ILO|W|E'
						Le type de message  inscrire doit tre entre des guillemets (' " ')
			G 	= Ce type d'entr crit un message au dbut et fin de l'installation 
					dans les logs de la trousse et du poste
			I 	= Ce type d'entr crit un message dans le log de la trousse 
					(spcifique)
			ILO = Ce type d'entr crit un message dans le log 
					d'installation du poste (gnral)
			W 	= Ce type d'entr crit un message d'avertissement lors de 
					l'installation de la trousse
			E 	= Ce type d'entr crit un message d'erreur lors de l'installation 
					de la trousse
		-Msg	:	Spcifie le message a inscrire dans les logs
						Le message  inscrire doit tre entre des guillemets (' " ')
		-RC			Spcifie le code de retour utilis lorsque l'installation choue.
						Le code de retour doit tre inscrit entre des guillemets (' " ')
	.EXEMPLE
		Write-Log -Type 'G|I|ILO|W|E' -Msg 'Installation complte'
	.NOTES
		Auteur 	:	Dany Fournier  
******************************************************************************#>  
	Param(
		[String]$Type, 
		[String]$Msg,
		[String]$RC
	)
	$error.clear()

	$global:date = Get-Date -format dd/MM/yyyy  
	$global:time = Get-Date -format HH:mm:ss    

	# Cration du journal d'vnement
	
	IF (![system.diagnostics.eventlog]::SourceExists("$strNOM_TROUSSE"))
	{New-Eventlog -logname "$strEVENTLOG_NAME" -Source "$strNOM_TROUSSE" -ErrorVariable $CreateLogErr}

	If ($CreateLogErr) {
		If($Verbose){Write-Host $CreateLogErr -ForegroundColor Red}
		Exit-Lib -LastExitCode 7056
	}
	
	# Selon le type de message
	Switch ($Type){ 
		"G" {				#G = General
			# crire dans le log principal
			Add-Content -Path $strRepLog$strMAIN_LOG `
				-Value "[$date]-[$time]-[INFORMATION]	$strNOM_TROUSSE - $Msg" -ErrorVariable LogErr   	
			# crire dans le log de la trousse
			If ($debut){
				Add-Content -Path $strRepLog$strTROUSSE_LOG -Value ("*" * "124")
				$global:debut = $false
			}
			Add-Content -Path $strRepLog$strTROUSSE_LOG `
				-Value "[$date]-[$time]-[INFORMATION]	$Msg" -ErrorVariable LogErr
			# crire Event log
			Write-Eventlog -logname "$strEVENTLOG_NAME" -Source "$strNOM_TROUSSE" `
				-EntryType Information -Message "$Msg" -id 0 -ErrorVariable LogErr
			# crire  l'cran
			Write-host "[$time] $Msg" -ForegroundColor "white"

        } 
		"I" {				#I = Information
			# crire dans le log de la trousse
			Add-Content -Path $strRepLog$strTROUSSE_LOG `
				-Value "[$date]-[$time]-[INFORMATION]	$Msg" -ErrorVariable LogErr
			# crire  l'cran
			If ($Verbose){Write-host "[$time] $Msg" -ForegroundColor "white"}
		} 
		"ILO" { 			#ILO = Information-Log-Only
			# crire dans le log principal
			Add-Content -Path $strRepLog$strMAIN_LOG `
				-Value "[$date]-[$time]-[INFORMATION]	$Msg" -ErrorVariable LogErr
			# crire dans le log de la trousse
			Add-Content -Path $strRepLog$strTROUSSE_LOG `
				-Value "[$date]-[$time]-[INFORMATION]	$Msg" -ErrorVariable LogErr
		} 
		"W" {				#W = Warning
			# crire dans le log de la trousse
			Add-Content -Path $strRepLog$strTROUSSE_LOG `
				-Value "[$date]-[$time]-[WARNING]	$Msg" -ErrorVariable LogErr
			# crire Event log
			If ($Msg -eq $null){$Msg = "Aucun message disponible"}
			Write-Eventlog -logname "$strEVENTLOG_NAME" -Source "$strNOM_TROUSSE" `
				-EntryType Warning -Message "$Msg" -id 3 -ErrorVariable LogErr
			# crire  l'cran
			If ($Verbose){Write-host "[$time]  -> $Msg" -ForegroundColor "yellow"}    		
		} 
		"E" {				#E = Error
			# crire dans le log principal
			Add-Content -Path $strRepLog$strMAIN_LOG `
				-Value ("[$date]-[$time]-[ERROR]		 $strNOM_TROUSSE - Vrifier le journal de la trousse.") `
				-ErrorVariable LogErr 
			# crire dans le log de la trousse
			Add-Content -Path $strRepLog$strTROUSSE_LOG `
				-Value "[$date]-[$time]-[ERROR]			$Msg" -ErrorVariable LogErr  
			Add-Content -Path $strRepLog$strTROUSSE_LOG `
				-Value ("[$date]-[$time]-[ERROR]		Une erreur est survenue lors de l'opration") `
				-ErrorVariable LogErr 
			# crire Event log
			If ($Msg -eq $null){$Msg = "Aucun message disponible"}
			Write-Eventlog -logname "$strEVENTLOG_NAME" `
				-Source "$strNOM_TROUSSE"	-EntryType Error -Message "$Msg" -id 0 `
				-ErrorVariable LogErr     		
			# crire  l'cran
			Write-host "[$time]  -> $Msg" -ForegroundColor "red"
			Write-host "[$time]  -> Une erreur est survenue lors de l'opration" `
				-ForegroundColor "red"
			Exit-Lib -LastExitCode $RCcode
		} 
	}

	If ($LogErr) {
		If($Verbose){Write-Host $LogErr -ForegroundColor Yellow}
		Exit-Lib -LastExitCode 7055
	}
	$erroractionpreference = "Continue"
} 


Function CMD-Exec {
<#******************************************************************************  
	.DESCRIPTION
		Cet fonction excute un programme et retourne l'errorlevel
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
	.SWITCH DISPONIBLE
		-PathToExec		: Spcifie l'emplacement du fichier a  excuter (Obligatoire)
							L'emplace de l'excutable doit tre entre des guillemets (' " ')
		-ParamToPush	: Spcifie les paramtres ncessaire pour l'excution du fichier (Facultatif)
							Les paramtres  inscrire doivent tre entre des guillemets (' " ')
		-Cache			: Switch On/Off qui spcifie si l'excution du fichier 
							doit tre afficher ou pas (Facultatif)
		-ManageRC		: Switch On/Off qui spcifie si l'erreur d'excution doit tre retourn ou 
							pas au script '.\include\install.ps1' (Facultatif)
		-NoWait			: Switch On/Off qui spcifie si le script doit attendre la fin de 
							l'excution du fichier ou pas (Facultatif)
	.EXEMPLE
		Cet exemple  excute un shell de commande
		CMD-Exec -PathToExec "$env:Windir\System32\cmd.exe" `
			-ParamToPush "/c echo ceci est exemple > c:\test.txt"

		Cet exemple  excute un shell de commande et retour le code de retour gnr par l'excutable.
			De cette faon, si le code de retour ne figure pas parmi la liste pr-ajoute au gabarit, 
				le trousseur peut crer une action particulire en fonction du RC.
		$Result = CMD-Exec -PathToExec "$env:Windir\System32\cmd.exe" `
			-ParamToPush "/c echo ceci est exemple > c:\test.txt" -NoWait -ManageRC
			
		Cet exemple  permet d'excuter un MSI
		CMD-Exec -PathToExec "$env:Windir\System32\msiexec.exe" `
			-ParamToPush "/i $strREP_SCRIPT\Sources\exemple.msi TRANSFORM=exemple.mst /qn /l:v $strREP_LOG$strNOM_TROUSSE_logMSI"
		
		Cet exemple  permet d'excuter un script Powershell
		CMD-Exec -PathToExec "$env:Windir\system32\windowspowershell\v1.0\powershell.exe" `
			-ParamToPush "-file $strREP_SCRIPT\Autres\Config\exemple.ps1"
		
		Cet exemple  permet d'excuter un script vbscript
		CMD-Exec -PathToExec "$env:Windir\System32\cscript.exe" `
			-ParamToPush "$strREP_SCRIPT\Sources\exemple.vbs"
		
		Cet exemple  permet d'excuter un batch file
		CMD-Exec -PathToExec "$env:Windir\System32\cmd.exe" `
			-ParamToPush "/c $strREP_SCRIPT\Sources\VieuxBatchFile.bat"
		
	.NOTES
		Auteur :	Dany Fournier & Simon Noiseux
		Prenez note que l'objet .Net 'System.Diagnostics.ProcessStartInfo' est utilis pour excuter 
			des fichiers dont l'extension est 'EXE'. Donc si vous voulez excuter un fichier dont
			l'extension est diffrent de 'EXE' (exe: MSI, PS1, VBS, MSP, CMD, BAT, PL ...) vous devez excuter
			le shell permettant de lancer ce fichier
				MSI = msiexec.exe
				MSP = msiexec.exe
				PS1 = Powershell.exe
				VBS = cscript.exe
				CMD = cmd.exe
				BAT = cmd.exe
				PL  = perl.exe
				...
******************************************************************************#> 
	param(
		[String]$PathToExec,
		[String]$ParamToPush,
		[Switch]$Cache,
		[Switch]$ManageRC,
		[Switch]$Wait
	)
	$error.clear()

	# Dfinition des prorits de la classe d'objet 'System.Diagnostics.ProcessStartInfo'
	$objStartInfo = New-Object System.Diagnostics.ProcessStartInfo
	$objStartInfo.FileName = $PathToExec
	$objStartInfo.arguments = $ParamToPush
	# Si la switch 'Cache' est utilise la fentre de l'excutable sera cach
	If ($Cache){
		$objStartInfo.WindowStyle = "Hidden"
		$objStartInfo.CreateNoWindow = $True
	}

	Try {$Process = [System.Diagnostics.Process]::Start($objStartInfo)}
	Catch {
		# Si une erreur ce produit lors de l'excution du fichier le RC 7011 termine le script
		Write-Log -Type "E" -Msg "RC:7011 - $error" "7011"}
	
	# Si la switch 'Wait' est utilise le script de la trousse attend la fin d'excution du fichier
	If (!($NoWait)){
		Do {If( -not $Process.HasExited ) {$Process.Refresh()}} 
		While( -not $Process.WaitForExit( 1000 ))
	}

	# Gestion d'erreur de l'excution du fichier
	If ($process.exitcode -eq 0){Write-Log -Type "I" -Msg "  --> La commande s'est excute avec succs"}
	# Si l'excutable retourne le code 3010, il est modifi pour 6010.
	# De cette faon l'engin de dploiement ne sera pas tent de redmarrer le client.
	# Ce code indique que le poste doit tre redmarr afin de complter l'installation
	ElseIf($process.exitcode -eq 3010){
		Write-Log -Type "I" -Msg "  --> La commande s'est excute avec succs"
		Write-Log -Type "W" -Msg "RC:6000 - Le poste doit tre redmarr."
		$global:WarningExitCode = 6000
		$error.clear()
	}
	# Pour tous les autres types de code de retour
	Else{
		# Si la switch 'ManageRC' est utilise le script renvoi le code de retour au fichier '.\include\install.ps1'
		If($ManageRC){Return $process.exitcode}
		Write-Log -Type "E" -Msg "RC:7010 - $error[0].FullyQualifiedErrorId" "7010"
		Write-Log -Type "E" -Msg "Le code de retour du manufacturier est : $process.exitcode"
	}

}


Function Copy-Files {
<#******************************************************************************  
	.DESCRIPTION
		Cet fonction copie des fichiers ou des dossiers 
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
		Mais elle est galement appele par .\ScriptInstall
	.SWITCH DISPONIBLE
		-SourceToCopy	: Spcifie le rpertoire source  copier (Obligatoire)
							Le rpertoire source doit tre entre des guillemets (' " ')
							Il n'est pas ncessaire que le dernier backslash ('\') soit prsent
		-FileToCopy		: Spcifie si des fichier spcifiques doivent tre copi (Facultatif)
							Si ce commutateur n'est pas spcifi le rpertoire COMPLET est copi
							Le fichier source doit tre entre des guillemets (' " ')
							Ce commutateur peut contenir:
								- un nom de fichier complet (un seul fichier sera copi)
								- un extension de fichier, SANS le point devant 
									(tous les fichiers portant cette extension seront copi)
								- un asterix (*) tous les fichiers a l'intrieur du rpertoire seront copis
		-CopyDestination: Spcifie le rpertoire de destination des items copis (Obligatoire)
							Le rpertoire de destination doit tre entre des guillemets (' " ')
		-ForceCopy		: Switch On/Off qui spcifie si cette fonction 
							crase les fichiers prsents qu'elle rencontre (Facultatif)
	.EXEMPLE
		Copy-Files -SourceToCopy $repToCopy -FileToCopy "*" -CopyDestination "c:\temp" -ForceCopy
	.NOTES
		Auteur	:	Dany Fournier & Simon Noiseux
******************************************************************************#>
	param(
		[String]$SourceToCopy,
		[String]$FileToCopy,
		[String]$CopyDestination,
		[Switch]$ForceCopy
	)
	$error.clear()
	$erroractionpreference = "SilentlyContinue"

	# Valide si le rpertoire source est valide
	If (Test-Path $SourceToCopy){
		# Valide si le rpertoire de destination existe
		If (!(Test-Path $CopyDestination)){
			Create-Folder $CopyDestination
			Start-Sleep -s 1
		}
		# Valide si il y seulement un fichier copier
		If ($FileToCopy.contains(".")){
			If (Test-Path "$SourceToCopy\$FileToCopy"){Copy-Item "$SourceToCopy\$FileToCopy" `
				"$CopyDestination"}
			Else{Write-Log -Type "E" -Msg "RC:7027 - Le fichier $SourceToCopy\$FileToCopy est introuvable" "7027"}
		}
		Else{	
			# Valide a l'intrieur du rpertoire source si il y a plusieurs fichiers  copier
			ForEach-Object {get-childitem $SourceToCopy -recurse -filter `
				*.$FileToCopy}| Where-Object {
				# Ensuite cre un objet comportant tous les fichiers a copier et 
				# 	remplacent le rpertoire de source par celui de destination
				$destination = $_.Fullname.replace("$SourceToCopy","$CopyDestination")
					If (($ForceCopy) -or (!(Test-Path $destination))){
					    Copy-item $_.Fullname $destination -Force
					}
					Else{
						Write-Log -Type "W" -Msg "RC:6000 - Le fichier $_.Fullname existe dj dans le rpertoire de destination."
						Write-Log -Type "W" -Msg "RC:6000 - Pour craser ce fichier, utilisez le commutateur '-FORCE'"
						$global:WarningExitCode = 6000
						$error.clear()
					}
				}
		}
	}
	# Si le rpertoire source est invalide la trousse retourne le code d'erreur 7041 et termine le script
	Else{Write-Log -Type "E" -Msg "RC:7026 - Le dossier source $SourceToCopy est introuvable" "7026"}		
	
	If ($error){Write-Log -Type "E" -Msg "RC:7020 - $error[0]" "7020"}
	Else{Write-Log -Type "I" -Msg "  --> La copie s'est complte avec succs"}
	
}

Function Registry-Operations {    
<#******************************************************************************  
	.DESCRIPTION 
		Cette fonction gre les diffrentes oprations applicable  la base de registre
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
		Mais elle est galement appele par .\ScriptInstall
	.SWITCH DISPONIBLE
		-RegKey 			: Ce commutateur spcifie la cl de registre (Obligatoire)
								La cl de registre contenu dans cette variable doit tre entre des guillemets (' " ') 
								Lorsque vous inscrivez la cl de registre il n'est pas ncessaire que vous inscriviez 
								des backslash ('\') avant et aprs
		-RegValue			: Ce commutateur spcifie la valeur  Crer/Modifier/Supprimer (Facultatif)
								La valeur du registre doit tre entre des guillemets (' " ') 
		-NewRegValueProperties : Ce commutateur spcifia la nouvelle valeur  inscrire lors de la Cration/Modification (Facultatif)
								La valeur du registre doit tre entre des guillemets (' " ') 
		Voici les commutateurs spcifiant le type d'opration  accomplir (L'un de ces commutateurs est Obligatoire)
			-GetValue		: Switch On/Off = Recherche d'une valeur
			-GetValues		: Switch On/Off = Recherche de plusieurs valeurs
			-SetValue		: Switch On/Off = Cration/Modification d'une valeur
			-DelValue		: Switch On/Off = Suppression d'une valeur
			-DelKey			: Switch On/Off = Suppression d'une cl
			-DelKeys		: Switch On/Off = Suppression d'une cl et de ses sous-cl
		Voici les commutateurs spcifiant la ruche  rechercher (L'un de ces commutateurs est Obligatoire)
			-LocalMachine	: Switch On/Off = HKEY_LOCAL_MACHINE
			-CurrentUser 	: Switch On/Off = HKEY_CURRENT_USER
		Voici les commutateurs spcifiant le type de valeur  rechercher/crer/supprimer (L'un de ces commutateurs est Obligatoire)
			-DWORD			: Switch On/Off = DWORD
			-QWORD			: Switch On/Off = QWORD
			-String			: Switch On/Off = STRING
			-XpandString	: Switch On/Off = XpandedString
			-MultiString	: Switch On/Off = MulitString
								Lorsque vous devez crer une valeur de type 'MultiString'. Vous devez inscrire une virgule (',')
									entre chacun des mots inclus dans la 'String'
			-Binary			: Switch On/Off = Binary
	.EXEMPLE
		Cet exemple  retourne la valeur recherche du registre est l'inscrit dans une variable
			La valeur recherchs doit se retrouver sous la cl de registre spcife, sinon elle ne sera pas trouve
		$MyReturndValue = Registry-operations -GetValue -CurrentUser `
			-RegKey "Software\GENIAL\Coccinelle" -String -RegValue "EstCeQuelleEstPresente?"

		Cet exemple  retourne les valeurs recherches du registre est l'inscrit dans une variable sous un array (tableau)
			La recherche de ces valeurs est excute  partir de la cl indique, les sous cls sont galement inspectes.
		$MyValuesInArray = Registry-operations -GetValues -LocalMachine `
			-RegKey "Software\GENIAL" -String -RegValue "OuSontElles?"

		Cet exemple  inscrit une valeure dans le registre
		Registry-operations -SetValue -LocalMachine -RegKey "Software\GENIAL\TheSimpsons" `
			-DWORD -RegValue "ExempleRegValue" -NewRegValueProperties "ExempleRegValueProperties"

		Cet exemple  supprimer une valeure dans le registre
		Registry-operations -DelValue -LocalMachine -RegKey "Software\GENIAL\TheSimpsons" `
			-QWORD -RegValue "Exemple"

		Cet exemple  supprime une cl du registre
			Si cette cl contient d'autres cls, le contenu de la cl demande sera supprim
				mais pas les sous-cls.
		Registry-operations -DelKey -CurrentMachine -RegKey "Software\ControlPanel\PersonnalisationGENIAL" `

		Cet exemple  supprime une cl et toutes celles prsente en dessous
		Registry-operations -DelKeys -CurrentMachine -RegKey "Software\RegKey2Delete"
		
	.NOTES
		Auteur :	Simon Noiseux  
******************************************************************************#>
	param (
		[string]$RegKey, 
		[string]$RegValue,
		[string]$NewRegValueProperties,
		[Switch]$LocalMachine,
		[Switch]$CurrentUser,
		[Switch]$DWORD,
		[Switch]$QWORD,
		[Switch]$String,
		[Switch]$XpandString,
		[Switch]$MultiString,
#		[Switch]$Binary,
		[Switch]$GetValue,
		[Switch]$GetValues,
		[Switch]$GetKey,
		[Switch]$SetValue,
		[Switch]$DelValue,
		[Switch]$DelKey,
		[Switch]$DelKeys
	)
	
	# Cette routine s'assure que la variable $RegKey ne contienne pas de backslash avant ni aprs
	If ($RegKey.EndsWith("\")) {$RegKey = $RegKey.TrimEnd('\')}	
	If ($RegKey.StartsWith("\")) {$RegKey = $RegKey.TrimStart('\')}	
	
	# Constante for the HKLM
	$HKLM = "&h80000002"
	# Constante for the HKCU
	$HKCU = "&H80000001"
	
	# Pour la recherche dans le registre nous utilisons la classe WMI Win32_ComputerSystem
	$computername = (Get-WmiObject -class Win32_ComputerSystem -computername ".").Name
	
	# Cette routine tablie la ruche a utiliser en fonction du commutateur utilis
	# Si l'un des 2 commutateurs primaire de la fonction n'a pas t inscrit le gabarit retourne le RC 7065
	If ($LocalMachine){$RegHive = $HKLM}
	ElseIf ($CurrentUser){$RegHive = $HKCU}
    Else {Write-Log -Type "E" -Msg "RC:7065 - Vous devez spcifier la ruche dsire" "7065"}

	# Cette routine dfinie des variables en fonction du type de valeur du registre choisie
		# La variable $ValueType est dfinie comme la valeur du registre
		# La $Value2Read $ValueType est dfinie comme la valeur du registre
	If ($QWORD){$ValueType = "QWORDValue" ; $Value2Read = "uValue"}
	ElseIf ($XpandString){$ValueType = "ExpandedStringValue" ; $Value2Read = "sValue"}
	ElseIf ($MultiString){$ValueType = "MultiStringValue" ; $Value2Read = "sValue"}
	ElseIf ($Binary){$ValueType = "BinaryValue" ; $Value2Read = "uValue"}
	ElseIf ($DWORD){$ValueType = "DWORDValue" ; $Value2Read = "uValue"}
	ElseIf ($String){$ValueType = "StringValue" ; $Value2Read = "sValue"}
	ElseIf ($GetKey){$ValueType = "EnumKey" ; $Value2Read = "ReturnValue"}
    ElseIf (($DelKeys)-or ($Delkey)-or ($DelValue)){}
    Else {Write-Log -Type "E" -Msg "RC:7066 - Vous devez spcifier le type de valeur  crer/supprimer" "7066"}

    # Dfinition la variable $objNamedValueSet pour qu'elle se connecte  l'objet WMI WbemScripting.SWbemNamedValueSet
	$objNamedValueSet = New-Object -COM "WbemScripting.SWbemNamedValueSet"

	# Ajout de la valeur cible qui fournira les demandes d'info au registre 64 et 32 bits 
	If ((Get-WmiObject Win32_OperatingSystem).OSArchitecture -eq "32 bits"){$objNamedValueSet.Add("__ProviderArchitecture", 32) | Out-Null}
	Else {$objNamedValueSet.Add("__ProviderArchitecture", 64) | Out-Null}

    # Dfinition de l'objet WMI WbemScripting.SWbemLocator
	$objLocator = New-Object -COM "Wbemscripting.SWbemLocator"
	$objServices = $objLocator.ConnectServer($computername,"root\default","","","","","",$objNamedValueSet)
	$objStdRegProv = $objServices.Get("StdRegProv")
		# Cette routine permet l'obtention d'une valeur dans le registre
	If ($GetValue){
		# Si l'arguments 'Verbose' et 'Detail' est utilis le gabarit retourne au trousseur des msg plus dtailles
		If (($Verbose) -and ($Detail)){	Write-Log -Type "I" -Msg " --> Recherche de la valeur : $RegValue"
										Write-Log -Type "I" -Msg " ---> Sous la cl : $RegKey"}
		# Si aucune valeur n'est spcifi le gabarit va terminer son excution avec le RC 7067
		If (!($RegValue)) {Write-Log -Type "E" -Msg "RC:7067 - Vous devez specifier une valeur  rechercher" "7067"}
        # Dfinition du type de valeur en fonction de l'action excut
		$ValueType = "Get"+$ValueType

		# Cette routine retourne la valeur demande dans la variable $OutParams
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq $ValueType}).Inparameters.SpawnInstance_()
		    ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
			($Inparams.Properties_ | where {$_.name -eq "Svaluename"}).Value = $RegValue
		$Outparams = $objStdRegProv.ExecMethod_($ValueType, $Inparams, "", $objNamedValueSet)
	}
	# Cette routine permet l'obtention de plusieurs valeurs identique dans le registre
	ElseIf ($GetValues){
		# Si l'arguments 'Verbose' et 'Detail' est utilis le gabarit retourne au trousseur des msg plus dtailles
		If (($Verbose) -and ($Detail)){	Write-Log -Type "I" -Msg " --> Recherche de la valeur : $RegValue"
											Write-Log -Type "I" -Msg " ---> Sous la structure de registre : $RegKey"}
		# Si aucune valeur n'est spcifi le gabarit va terminer son excution avec le RC 7067
		If (!($RegValue)) {Write-Log -Type "E" -Msg "RC:7067 - Vous devez specifier une valeur  rechercher" "7067"}
        # Dfinition du type de valeur en fonction de l'action excut
        $ValueType = "Get"+$ValueType
		
		# Cette routine numre la liste des sous-cls de celle demand et l'inscrit en tant que tableau sous la variable #Outparams
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq "EnumKey"}).Inparameters.SpawnInstance_()
            ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
		$Outparams = $objStdRegProv.ExecMethod_("EnumKey", $Inparams, "", $objNamedValueSet)
		
		#  partire de liste de sous cl cre par la routine prcdente, la routine suivante 
		#	intrroge chacune des valeurs afin d'obtenir la liste des valeurs demandes sous la cl spcifie
		ForEach ($subKeys in ($Outparams.Properties_ | where {$_.name -eq "sNames"}).Value) {
			# Afin d'obtenir la liste des valeurs demandes, cette routine utilise la fonction 'Registry-Operations'
			# 	et elle enregistre les rsultats dans la variable $EntryFound
			$EntryFound = Registry-Operations -GetValue -LocalMachine -RegKey "$RegKey\$subKeys" -RegValue $RegValue -STRING
			# Si la variable $EntryFound n'est pas null, cette valeur est inscrite dans le tableau '$AskedList'
			If ($EntryFound -notlike "") {$AskedList = $AskedList;$EntryFound}
		}
	}
	# Cette routine permet la cration/modification d'une valeur dans le registre
	ElseIf ($GetKey){
		# Si l'arguments 'Verbose' et 'Detail' est utilis le gabarit retourne au trousseur des msg plus dtailles
		If (($Verbose) -and ($Detail)){	Write-Log -Type "I" -Msg " ---> Sous la cl : $RegKey"}

		# Cette routine retourne la valeur demande dans la variable $OutParams
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq $ValueType}).Inparameters.SpawnInstance_()
		    ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
		$Outparams = $objStdRegProv.ExecMethod_($ValueType, $Inparams, "", $objNamedValueSet)
	}
	ElseIF ($SetVAlue) {
		# Si l'arguments 'Verbose' et 'Detail' est utilis le gabarit retourne au trousseur des msg plus dtailles
		If (($Verbose) -and ($Detail)){	Write-Log -Type "I" -Msg " --> Recherche de la valeur : $RegValue"
										Write-Log -Type "I" -Msg " ---> Sous la cl : $RegKey"}
		# Si aucune valeur n'est spcifi le gabarit va terminer son excution avec le RC 7067
		If (!($RegValue)) {Write-Log -Type "E" -Msg "RC:7067 - Vous devez specifier une valeur  rechercher" "7067"}
		# Si la nouvelle valeur n'est pas spcifi le gabarit va terminer son excution avec le RC 7068
		If ($NewRegValueProperties -like $null){Write-Log -Type "E" -Msg "RC:7068 - Vous devez specifier la nouvelle une valeur  inscrire" "7068"}
        # Dfinition du type de valeur en fonction de l'action excut
		$ValueType = "Set"+$ValueType
		# Cette routine s'assure que le cl parent  la valeur demande existe
		#	Si elle n'existe pas elle la cre
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq "CreateKey"}).Inparameters.SpawnInstance_()
            ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
		$Outparams = $objStdRegProv.ExecMethod_("CreateKey", $Inparams, "", $objNamedValueSet)
 
		# Cette routine cre la valeur demande
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq $ValueType}).Inparameters.SpawnInstance_()
            ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
			($Inparams.Properties_ | where {$_.name -eq "Svaluename"}).Value = $RegValue
            # La mthode de cration d'une valeur diffre lgrement si le type de valeur est une 'MultiString'
			#	Si c'est le cas la nouvelle valeur doit tre converti en tableau
			If ($MultiString){($Inparams.Properties_ | where {$_.name -eq $Value2Read}).Value = $NewRegValueProperties.split(",")}
			Else{($Inparams.Properties_ | where {$_.name -eq $Value2Read}).Value = $NewRegValueProperties}
		$Outparams = $objStdRegProv.ExecMethod_($ValueType, $Inparams, "", $objNamedValueSet)
	}
	# Cette routine permet la suppression d'une valeur dans le registre
	ElseIF ($DelValue) {
		# Si aucune valeur n'est spcifi le gabarit va terminer son excution avec le RC 7067
		If (!($RegValue)) {Write-Log -Type "E" -Msg "RC:7067 - Vous devez specifier une valeur  rechercher" "7067"}
		# Cette routine supprime la valeur demande
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq "DeleteValue"}).Inparameters
		    ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
			($Inparams.Properties_ | where {$_.name -eq "Svaluename"}).Value = $RegValue
		$Outparams = $objStdRegProv.ExecMethod_("DeleteValue", $Inparams, "", $objNamedValueSet)
		$Result="Valeur supprime"
	}
	# Cette routine permet la suppression d'une cl dans le registre
	#	Les sous-cls contenu sous celle-ci ne sont pas supprimes
	
	ElseIF ($DelKey) {
        $Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq "DeleteKey"}).Inparameters
		    ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
		$Outparams = $objStdRegProv.ExecMethod_("DeleteKey", $Inparams, "", $objNamedValueSet)
		$Result="Cl supprime"
	}
	# Cette routine permet la suppression d'une cl et de ses sous-clsdans le registre
	#	Les sous-cls contenu sous celle-ci seront supprimes
	ElseIF ($DelKeys) {
        $ValueType = "Get"+$ValueType
		# Cette routine numre la liste des sous-cls de celle demand et l'inscrit en tant que tableau sous la variable #Outparams
		$Inparams = ($objStdRegProv.Methods_ | where {$_.name -eq "EnumKey"}).Inparameters.SpawnInstance_()
            ($Inparams.Properties_ | where {$_.name -eq "Hdefkey"}).Value = $RegHive
			($Inparams.Properties_ | where {$_.name -eq "Ssubkeyname"}).Value = $RegKey
		$Outparams = $objStdRegProv.ExecMethod_("EnumKey", $Inparams, "", $objNamedValueSet)

		#  partire de liste de sous cl cre par la routine prcdente, la routine suivante 
		#	intrroge supprime chacune des cls sous celle demande
		ForEach ($subKeys in ($Outparams.Properties_ | where {$_.name -eq "sNames"}).Value) {
			Switch($RegHive){
                {$HKLM}{
                    If ($subKeys -notlike "") {Registry-operations -DelKeys -LocalMachine -RegKey "$RegKey\$subKeys"}   
                    Registry-Operations -DelKey -LocalMachine -RegKey "$RegKey"
                }
                {$HKCU}{
                    If ($subKeys -notlike "") {Registry-operations -DelKeys -CurrentUser -RegKey "$RegKey\$subKeys"}   
                    Registry-Operations -DelKey -CurrentUser -RegKey "$RegKey"
                }
            }


			If ($EntryFound -notlike "") {$AskedList = $AskedList;$EntryFound}
		}
	}
	# Si aucun commutateurs spcifiant le type d'opration  accomplir est prsent le gabarit gnre le RC 7069
	Else {Write-Log -Type "E" -Msg "RC:7069 - Vous devez spcifier l'opration de registre  excuter" "7069"}

	# Si le commutateur de type d'opration 'GetValue' est spcifi
	#	la fonction 'Registry-Operation' retourne la valeur obtenue
	If ($GetValue) {
		If (($Outparams.Properties_ | where {$_.name -eq $Value2Read}).Value -notlike "") {
			$Result=($Outparams.Properties_ | where {$_.name -eq $Value2Read}).Value
			Return $Result
		}
	}
	# Si le commutateur de type d'opration 'GetValues' est spcifi
	#	la fonction 'Registry-Operation' retourne la liste de valeurs obtenue
	ElseIf ($GetValues) {Return $AskedList}
	# Si le commutateur de type d'opration 'SetValue' est spcifi
	#	la fonction 'Registry-Operation' retourne la nouvelle valeur inscrite
    ElseIf ($SetValue) {$Result=($Inparams.Properties_ | where {$_.name -eq $Value2Read}).Value}
	ElseIf ($GetKey) {If (($Outparams.Properties_ | where {$_.name -eq $Value2Read}).Value -eq 0){Return $True}
					  Else {Return $False}}
}


Function Find-In-File-Replace {
<#******************************************************************************
	.DESCRIPTION  
		Recherche une 'String' dans un fichier et remplace par une autre 'String'
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
	.SWITCH DISPONIBLE
		-FileToRead		: Spcifie le fichier  lire (Obligatoire)
		-StringToFind	: Spcifie la ligne  rechercher (Obligatoire)
		-Replacement	: Spcifie la ligne de remplacement (Obligatoire)
	.EXEMPLE
		Find-In-File-Replace -FileToRead "C:\travail\FichierSecretdeMaggie.txt" `
			-StringToFind 'BartEstGros' -Replacement 'MaisPasPlusQuePAPA'
	.NOTES  
		Auteur :	Simon Noiseux  
******************************************************************************#>
	Param(
		[String]$FileToRead,
		[String]$StringToFind,
		[String]$Replacement
	)
	$error.clear()
	$erroractionpreference = "SilentlyContinue"

	#Valide si le fichier  lire existe
	If (Test-Path $FileToRead){
		# Recherche de la ligne a remplacer dans le fichier spcifi
		If (Select-String $StringToFind $FileToRead) {
			# Modification de la ligne trouve
			(Get-Content $FileToRead) | Foreach-Object {$_ -replace $StringToFind, `
				$Replacement}| Set-Content $FileToRead
		}
		Else{Write-Log -Type "E" -Msg "RC:7060 - Vous ne pouvez pas modifier La 'String' $StringToFind car elle n'existe pas dans le fichier $FileToRead." "7060"}
	}
	Else{Write-Log -Type "E" -Msg "RC:7061 - Le fichier  $FileToRead  n'existe pas. Vous ne pouvez donc pas le modifier." "7061"}
	
	If ($error){Write-Log -Type "E" -Msg "RC:7062 - $error" "7062"}
	Else{Write-Log -Type "I" -Msg "  --> La 'String' a t modife avec succs."}
	
}


Function Apend-File-In-File {
<#******************************************************************************  
	.DESCRIPTION
		Importe le contenu d'un fichier texte vers un autre fichier.
		Si ce nouveau fichier n'existe pas, un nouveau sera cre
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
		Mais elle est galement appele par .\ScriptInstall
	.SWITCH DISPONIBLE
		-FileRead	: Spcifie le fichier  lire (Obligatoire)
		-Dest		: Spcifie le rpertoire de destination du nouveau fichier (Obligatoire)
		-File		: Spcifie le nom du nouveau fichier  crer (Obligatoire)
	.EXEMPLE
		Apend-File-In-File -FileRead $strREP_SCRIPT\Include\Lib.ps1 -Dest 'c:\tata' -File 'Uninstall.ps1'
	.NOTES
		Auteur :	Dany Fournier  
******************************************************************************#>
	Param(
		[String]$FileRead,
		[String]$Dest,
		[String]$File
	)
	$error.clear()
	$erroractionpreference = "SilentlyContinue"
	
	# Valide si le fichier de source est existe
	If (!(Test-Path $FileRead)){
		Write-Log -Type "E" -Msg "RC:7001 - Le fichier source $FileRead est introuvable" "7001"}
	Else{
		# Si le rpertoire de destination n'existe pas il le cre
		If(!(Test-Path $Dest)){Create-Folder -Path $Dest -itemtype directory}
		# Importation du contenu du fichier vers le nouveau
		Get-Content $FileRead | Out-File "$Dest\$File" -append
	}
	
	If ($error){Write-Log -Type "E" -Msg "RC:7000 - $error" "7000"}
	Else{
		# Validation si le compteur global est gale  '0'
		# Ce compteur est utilis pour viter de rpter de faon conscutive le mme message 
		#	lorsque cette fonction est utilise dans une boucle
		If ($Compteur -eq 0){
			Write-Log -Type "I" -Msg "  --> Le fichier a t cr avec succs."
			$Global:Compteur=$Compteur+1
		}
	}

}


Function Modify-XML-Attribute {
<#******************************************************************************  
	.DESCRIPTION 
		Cette fonction permet la modification d'une valeur inscrite dans un fichier XML
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
	.SWITCH DISPONIBLE
		-XMLInfile			: Fichier XML  lire (Obligatoire)
		-XMLOutfile			: Fichier XML  crer. Ce fichier peut tre le mme que celui  lire (Obligatoire)
		-XMLTagPath			: Tag XML  rechecher (Obligatoire)
		-NodeToModify		: Node XML  modifier (Obligatoire)
		-AttributeToModify	: Proprit du node  modifier (Obligatoire)
		-DataToModify		: Nouvelle valeur du node (Obligatoire)
	.EXEMPLE
		Modify-XML-Attribute -XMLInfile $XMLFile `
			-XMLOutfile 'C:\temp\file.xml' -XMLTagPath Configuration.OptionState -NodeToModify 'Accessfiles' `
			-AttributeToModify "State" -DataToModify "absent"
	.NOTES
		Auteur :	Simon Noiseux  
******************************************************************************#>
	param(
		[String]$XMLInfile,
		[String]$XMLOutfile,
		[String]$XMLTagPath,
		[String]$NodeToModify,
		[String]$AttributeToModify,
		[String]$DataToModify
	)
	$error.clear()
	$erroractionpreference = "SilentlyContinue"

	# Validation de la prsence du fichier XML source 
	If (Test-Path $XMLInfile){
		# Lecture du fichier XML
		$xml = [xml](Get-Content $XMLInfile)
		# Recherche du node  modifier
		$xml.$XMLTagPath | Where-Object {$_.id -eq $NodeToModify} | 
			ForEach-Object {$_.$AttributeToXModify = $DataToModify}
	}
	Else{Write-Log -Type "E" -Msg "RC:7037 - Le fichier XML : $XMLInfile  n'existe pas" "7037"}
	
	# Sauvegarde du fichier XML
	If (Test-path(Split-Path $XMLOutfile)){$xml.Save($XMLOutfile)}
	Else{Write-Log -Type "E" -Msg "RC:7036 - Une erreur est survenue lors de l'enregistrement de fichier XML : $XMLOutfile" "7036"}

	If ($error){Write-Log -Type "E" -Msg "RC:7035 - $error" "7035"}
	Else{
		# Validation si le compteur global est gale  '0'
		# Ce compteur est utilis pour viter de rpter de faon conscutive le mme message 
		#	lorsque cette fonction est utilise dans une boucle
		If ($Compteur -eq 0){
			Write-Log -Type "I" -Msg "  --> Le fichier XML a t modifi avec succs."	
			$Global:Compteur=$Compteur+1
		}
	}
}


Function Delete-File-Folder {
<#******************************************************************************  
	.DESCRIPTION 
        Cette fonction permet la suppression un fichier ou un dossier
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
	.SWITCH DISPONIBLE
		-RepToDelete	: Rpertoire source contenant des fichiers  supprimer (Obligatoire)
		-FilesToDelete	: Fichiers  supprimer (Facultatif)
							Ce commutateur peut contenir:
								- un nom de fichier complet (un seul fichier sera supprim)
								- un asterix (*) tous les fichiers a l'intrieur du rpertoire seront copis.
									Toutefois vous devez utiliser le commutateur 'Recursive' si 
										vous dsirez supprimer la structure complte du rpertoire.
		-Recursive		: Switch On/Off qui indique la structure complte du rpertoire 
							doit tre supprimer (Facultatif)
	.EXEMPLE
		Cet exemple  supprime  tous les fichiers mais laisse la structure de rpertoire intact
		Delete-File-Folder -RepToDelete $RepInstall -FilesToDelete "*"
		
		Cet exemple  supprime toute la structure de rpertoire
		Delete-File-Folder -RepToDelete "C:\Temp\Nouveau dossier" `
			-FilesToDelete "*" -Recursive
	.NOTES
		Auteur :	Simon Noiseux  
******************************************************************************#>
	param(
		[String]$RepToDelete,
		[String]$FilesToDelete,
		[Switch]$Recursive
	)
	$error.clear()
	$erroractionpreference = "SilentlyContinue"

	If ($RepToDelete -eq ""){Write-Log -Type "E" -Msg "RC:7045 - Un rpertoire doit tre spcifi." "7045"}
	# Validation si le rpertoire a supprimer existe
	If (Test-Path $RepToDelete){
		# Si le nom de rpertoire ne contient pas de '\'  la fin il est ajout
		If (!($RepToDelete.EndsWith("\"))) {$RepToDelete = $RepToDelete+"\"}
		
		# Boucle permettant la suppression d'un seul fichier
		If (($FilesToDelete -ne "") -and ($FilesToDelete -ne "*")){
				If (Test-Path $RepToDelete$FilesToDelete){Remove-Item -Path $RepToDelete$FilesToDelete}
				Else{
					Write-Log -Type "W" -Msg "RC:6000 - Le fichier spcifi ($RepToDelete$FilesToDelete) ne peut tre supprim, car il n'existe pas"
					$global:WarningExitCode = 6000
					$error.clear()
				}
		}
		# Boucle permettant la suppression de tous les fichiers
		#	Toutefois la structure de rpertoire est laiss intact
		ElseIf (($FilesToDelete -ne "") -and ($FilesToDelete -eq "*") -and (!($Recursive))){
			ForEach-Object {Get-ChildItem $RepToDelete} | Where-Object {
				$_.extension} | Remove-Item
			If ((Get-ChildItem $RepToDelete) -eq $null) {Remove-Item -Path $RepToDelete -Force}
		}
		# Boucle permettant la suppression complte de la structure de rpertoire
		ElseIf ($Recursive){Remove-Item -Path $RepToDelete -Recurse -Force}
	}
	Else{
		Write-Log -Type "W" -Msg "RC:6000 - Le rpertoire spcifi ($RepToDelete) ne peut tre supprim, car il n'existe pas"
		$global:WarningExitCode = 6000
		$error.clear()
	}
	
	If ($error){
		Write-Log -Type "W" -Msg "RC:6000 - $error"
		$global:WarningExitCode = 6000
		$error.clear()
	}
	Else{Write-Log -Type "I" -Msg "  --> La suppression s'est bien droule."}
}


Function Show-Msgbox {
<#******************************************************************************  
	.DESCRIPTION 
		Affiche un message ou une question
		
		Cette fonction peut-tre appele par le script d'installation de la trousse '.\include\install.ps1'
	.SWITCH DISPONIBLE
	   	-message	: Message que vous voulez envoy  l'cran 
	.EXEMPLE
		$rc=Show-Msgbox -message "Question?" -icon "question" -button "YesNo" -title "titre"
	.NOTES
		Auteur :	Dany Fournier  
******************************************************************************#>
	Param(
	   	[String]$message=$(Throw "You must specIfy a message"),
	    [String]$button="okonly",
	    [String]$icon="information",
	    [String]$title="Message Box"
	)
	# Buttons: OkOnly, OkCancel, AbortRetryIgnore, YesNoCancel, YesNo, RetryCancel
	# Icons: Critical, Question, Exclamation, Information
	[reflection.assembly]::loadwithpartialname("microsoft.visualbasic") | Out-Null
	[microsoft.visualbasic.interaction]::Msgbox($message,"$button,$icon",$title)
}


Function Exit-Lib {
<#******************************************************************************  
	.DESCRIPTION 
		Fonction permettant la fermeture complte du script de la trousse
	.SWITCH DISPONIBLE
		-ExitCode	: Code de retour que vous voulez renvoyer lors de la fermeture du script
	.EXEMPLE
		Write-Log -Type "E" -Msg "RC:7055 - $error"
		Exit-Lib -LastExitCode 7055
	.NOTES
		Auteur :	Simon Noiseux  
******************************************************************************#>
	Param([String]$ExitCode)
	$global:do_exit = $true
	Exit-Script -LastExitCode $ExitCode
}


Function Hide-Soft-Ctrl-Panel{
<#******************************************************************************  
	.DESCRIPTION
		Fonction permettant de masquer l'entre du logiciel dans le panneau
			de configuration 'Add and Remove Programs'
	.EXEMPLE
		HideSoftCtrlPanel -Logiciel	"Logiciel DSQ"
	.NOTES
		Auteur :	Simon Noiseux  
******************************************************************************#>
	Param([String]$Logiciel)
	Write-Log -Type "I" -Msg "Masque de l'entre prsente dans Ajout Suppression de programmes"
	Registry-Operations -SetValue -LocalMachine -RegKey "$UninstallPath$Logiciel" `
		-RegValue "SystemComponent"	-NewRegValueProperties 1 -DWORD
}


Function Get-Hardware-Type {
<#******************************************************************************  
	.DESCRIPTION
		Permet de savoir le type de matriel sur lequel Windows est install.
		La variable retourne par cette fonction est '$HardwareType'
			Cette variable peut-tre utilis pour dfinir si l'installation de la trousse peut ou pas s'excuter

		Si jamais le script n'est pas en mesure de dterminer quel est le type de hardware
			sur lequel vous dsirez installer la trousse, cette fonction ce terminera
			avec le code de retour 7005
		
		Cette fonction est appele par '.\ScriptInstall'
	.EXEMPLE
		$HardwareType = Get-Hardware-Type
	.NOTES
		Auteur	:	Simon Noiseux  
******************************************************************************#>
	# Recherche du matriel en fonction du chassis (requte WMI)
	# pour un dfinition plus prcise des types de chassis disponible
	#	consultez le site web : http://technet.microsoft.com/en-us/library/ee156537.aspx
	Switch ((Get-WmiObject -class Win32_SystemEnclosure -computername ".").ChassisTypes) { 
			{($_ -eq 3) -or ($_ -eq 4) -or ($_ -eq 5) -or ($_ -eq 6)`
				-or ($_ -eq 7) -or ($_ -eq 15) -or ($_ -eq 16)}
	    		{$FindHardwareType="IsDesktop"}
			{($_ -eq 8) -or ($_ -eq 9) -or ($_ -eq 10) -or ($_ -eq 11)`
				-or ($_ -eq 12) -or ($_ -eq 14) -or ($_ -eq 18) -or ($_ -eq 21) -or ($_ -eq 31) -or ($_ -eq 35)}
				{$FindHardwareType="IsLaptop"}
			"1" {$FindHardwareType="IsVirtual"}
			{($_ -eq "23") -or ($_ -eq "17")} 
				{$FindHardwareType="IsServer"}
			Default {
				Write-Host "RC:7005 - L'installation de cette trousse ne peut tre faite sur ce type de matriel"
				Exit-Lib -LastExitCode 7005
				}
	}
	Return $FindHardwareType
}


Function Check-Logs-Dir {
<#******************************************************************************  
	.DESCRIPTION
		Permet de savoir l'emplacement du rpertoire de log en fonction du type d'OS.
		La variable retourne par cette fonction est '$strRepLog'

		Lorsque l'OS est un Windows 7 ou XP, le rpertoire de log est localis sous C:\Programmes Files\DSQ\Log
		Lorsque l'OS est un Windows 2003 ou 2003, le rpertoire de log est localis sous D:\Log
			Ces emplacements sont dfinis par les variables '$strREP_LOG_POSTE' & $strREP_LOG_POSTE
			Ces variables sont dfinis dans le script powershell '.\include\config.ps1'
		
		Cette fonction est appele par '.\ScriptInstall'
	.EXEMPLE
		$strRepLog = Check-Logs-Dir
	.NOTES
		Auteur	:	Simon Noiseux  
******************************************************************************#>
	$Global:OStype = (Get-WmiObject -class Win32_OperatingSystem -computername ".").Caption
	
	# Valide le type de Systme d'exploitation
	If (($Ostype.ToUpper().Contains("Server".ToUpper())) -and # Le Systme d'exploitation dtect est 'Windows Server'
		#Valide si un disque logique D: est prsent
		(Get-WmiObject -class Win32_LogicalDisk -computername "." | `
			# Un disque physique D: est prsent, donc les logs seront crs sous D:\Log
			Where-object {$_.DeviceID -eq "D:" -and $_.DriveType -eq "3"})){$strREP_LOG = "D:\$strREP_LOG"+"Trousses\"}
	Else{
		# Le Systme d'exploitation dtect n'est pas 'Windows Server'
		# C'est donc un poste
#		If ($OSArchitecture -eq "64 bits"){$strREP_LOG = "$env:ProgramW6432\DSQ\$strREP_LOG"}
		If ($OSArchitecture -eq "64 bits"){$strREP_LOG = "$env:ProgramFiles\DSQ\$strREP_LOG"}
		Else {$strREP_LOG = "$env:ProgramFiles\DSQ\$strREP_LOG"}
	}	
	
	Create-Folder $strREP_LOG
	Return $strREP_LOG
}


Function Is-Admin {
<#******************************************************************************  
	.DESCRIPTION
		Valide si le contexte d'excution de la trousse est en mode 'administrateur'
		 
		Cette fonction est appele par '.\ScriptInstall'
	.EXEMPLE
		Is-Admin
	.NOTES
		Auteur	:    Dany Fournier  
******************************************************************************#>
	$wid	 = [System.Security.Principal.WindowsIdentity]::GetCurrent()
	$prp	 = New-Object System.Security.Principal.WindowsPrincipal($wid)
	$adm	 = [System.Security.Principal.WindowsBuiltInRole]::Administrator
	$IsAdmin = $prp.IsInRole($adm)
	$time 	 = Get-Date -format HH:mm:ss
	
	Write-host "[$time] Validation des droits d'excution de l'utilisateur"
	
	If ($IsAdmin){Write-host "[$time] Excution en mode administrateur"}
	Else{
		$time = Get-Date -format HH:mm:ss
		Write-host "[$time]  --> L'installation de cette trousse  ncessite des droits d'administrateur" -ForegroundColor "red"
		Write-host "[$time]  --> Une erreur est survenue lors de l'opration" -ForegroundColor "red"
		Exit-Lib -ExitCode 7030
	}
}


Function Use-ActiveSetup {
<#******************************************************************************  
	.DESCRIPTION 
		Fonction permettant la cration de l'automatisme de personnalisation (Active Setup)
			de la session utilisateur
		Pour que cet automatisme fonctionne vous devez ajouter vos routines 
			dans le rpertoire '.\Autres\Active Setup' de la trousse
		
		Cette fonction est appele par '.\ScriptInstall'
	.SWITCH DISPONIBLE
		-Trousse		: Nom de la trousse, inscrit automatiquement avec la variable '$strNOM_TROUSSE' 
							(Obligatoire)
		-CMDtoExec		: Nom et emplacement de l'excutable (Obligatoire)
		-VersionTrousse	: Version de la trousse, inscrit automatiquement avec la variable '$strNOM_TROUSSE_VERSION' (Obligatoire
	.EXEMPLE
		Cet exemple  permet la cration d'un active setup avec un batch file
		Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
			-CMDtoExec "cmd.exe /c $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
			-VersionTrousse $strNOM_TROUSSE_VERSION
		
		Cet exemple  permet la cration d'un active setup avec un script powershell
		Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
			-CMDtoExec "powershell.exe -file $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
			-VersionTrousse $strNOM_TROUSSE_VERSION

		Cet exemple  permet la cration d'un active setup avec un script visualbasic
		Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
			-CMDtoExec "cscript.exe $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
			-VersionTrousse $strNOM_TROUSSE_VERSION

		Cet exemple  permet la cration d'un active setup avec une cl de registre
		Use-ActiveSetup -Trousse $strNOM_TROUSSE"_$i" `
			-CMDtoExec "regedit.exe /s $guilmt$DefaultProgramsDir$RepDestCfgFiles\$_$guilmt" `
			-VersionTrousse $strNOM_TROUSSE_VERSION

	.NOTES
		Auteur :	Simon Noiseux  
******************************************************************************#>
	Param(
		[String]$Trousse,
		[String]$CMDtoExec,
		[String]$VersionTrousse
	)
	$error.clear()
	$erroractionpreference = "SilentlyContinue"

	# Cration de l'Active Setup grce  la fonction 'Write Registry'
	Registry-Operations -SetValue -LocalMachine -RegKey "$ActiveSetupPath\!$Trousse" -RegValue "ComponentID" `
		-NewRegValueProperties "$Trousse" -STRING
	Registry-Operations -SetValue -LocalMachine -RegKey "$ActiveSetupPath\!$Trousse" -RegValue "StubPath" `
		-NewRegValueProperties $CMDtoExec -STRING
	If ((Get-ItemProperty -Path "HKLM:$ActiveSetupPath\!$Trousse").Version -ne $null) {
		$VersionTrousse = [int] (Get-ItemProperty -Path "HKLM:$ActiveSetupPath\!$Trousse").Version + 1}
	Registry-Operations -SetValue -LocalMachine -RegKey "$ActiveSetupPath\!$Trousse" -RegValue "Version" `
		-NewRegValueProperties $VersionTrousse -STRING
#	Registry-Operations -SetValue -LocalMachine -RegKey "$ActiveSetupPath\!$Trousse" -RegValue "Locale" `
#		-NewRegValueProperties "FR" -STRING
#	Registry-Operations -SetValue -LocalMachine -RegKey "$ActiveSetupPath\!$Trousse" -RegValue "DontAsk" `
#		-NewRegValueProperties 2 -DWORD
#	Registry-Operations -SetValue -LocalMachine -RegKey "$ActiveSetupPath\!$Trousse" -RegValue "IsInstalled" `
#		-NewRegValueProperties 1 -DWORD
	If ($error){Write-Log -Type "E" -Msg "RC:7050 - Une erreur est survenue lors de la cration de l'Active Setup" "7050"}
	Else{
		# Validation si le compteur global est gale  '0'
		# Ce compteur est utilis pour viter de rpter de faon conscutive le mme message 
		#	lorsque cette fonction est utilise dans une boucle
		If ($Compteur -eq 0){
			Write-Log -Type "I" -Msg "  --> La configuration de l'Active-Setup pour la trousse a fonctionn."
			$Global:Compteur=$Compteur+1
		}
	}
}


Function Compare-OSarchi-ProgArchi  {
<#******************************************************************************  
	.DESCRIPTION 
		Permet de la dtection de l'architecture du poste et valide ensuite si le rpertoire 
			d'installation est 'C:\Programmes Files' ou 'C:\Programmes Files(x86)'
			
		Cette fonction est appele par '.\ScriptInstall'
	.EXEMPLE
		Compare-OSarchi-ProgArchi 
	.NOTES
		Auteur :	Simon Noiseux
******************************************************************************#>
	$error.clear() 
	$erroractionpreference  = "SilentlyContinue"

	If ($is64bitPowershell) {$ShellArchitecture = "64 bits"}
	Else {$ShellArchitecture = "32 bits"}

	Write-Log -Type "I" -Msg "Validation de l'architecture du systme (x86 vs x64)"
	Write-Log -Type "I" -Msg " --> L'architecture du client est : $OSArchitecture"
	Write-Log -Type "I" -Msg " --> La trousse est excute dans un shell : $ShellArchitecture"
	Write-Log -Type "I" -Msg " --> L'architecture du produit est : $ProgramArchitecture"
	# Cette routine dfinie les variables en fonction de l'architecture 32 bits du systme
	# 	Les variables dfinies par cette routine sont :
	#		$UninstallPath
	#		$DefaultProgramsDir
	#		$InstallDir
	If ($OSArchitecture -eq "32 bits"){
		$Global:UninstallPath = $WindowsRegistry+$UninstallPathUni
		$Global:DefaultProgramsDir = "$env:ProgramFiles\"
        $Global:ProgramFiles = $env:ProgramFiles
		If ($ProgramArchitecture -eq "64 bits") {Write-Log -Type "E" -Msg "RC:7022 - Vous ne pouvez pas installer une application 64 bits sur un client 32 bits." "7022"}
		ElseIf ($InstallParam -like "") {$Global:InstallDir = "$Global:ProgramFiles\$DefaultDestDir"}
	}
	# Cette routine dfinie les variables en fonction de l'architecture 64 bits du systme
	#	Les variables dfinies par cette routine dpendent de l'architecture du produit,
	#		sauf celle dfinissant le rpertoire par dfaut de Program Files '$DefaultProgramsDir' qui pointe sur C:\Programs Files
	ElseIf($OSArchitecture -eq "64 bits"){		
		# Cette routine dfini les variables suivantes lorsque le produit est 32 bits sur un systme 64 bits
		#		$UninstallPath
		#		$InstallDir
		
		$Global:DefaultProgramsDir = "$env:ProgramW6432\"
		
		If ($ProgramArchitecture -eq "32 bits") {
			$Global:UninstallPath = $WindowsRegistryW6432node+$UninstallPathUni
			$Global:DefaultProgramsDir = "$env:ProgramW6432\"
            $Global:ProgramFiles = ${env:ProgramFiles(x86)}
            If ($InstallParam -like ""){ $Global:InstallDir = "$Global:ProgramFiles\$DefaultDestDir"
                
            }
		}
		# Cette routine dfini les variables suivantes lorsque le produit est 64 bits sur un systme 64 bits
		#		$UninstallPath
		#		$InstallDir
		ElseIf ($ProgramArchitecture -eq "64 bits") {
			$Global:UninstallPath = $WindowsRegistry+$UninstallPathUni
			
			$Global:ProgramFiles = $env:ProgramW6432
            If ($InstallParam -like "") {$Global:InstallDir = "$Global:ProgramFiles\$DefaultDestDir"}
		}
		# Cette routine dfini les variables suivantes lorsque le produit est hybrid sur un systme 64 bits
		#		$UninstallPath
		#		$InstallDir
		# On dfinit un produit comme tant hybrid lorsque son assistant d'installation contient 
		#	les sources d'installations 64 et 32 bits du mme produit
		ElseIf ($ProgramArchitecture -eq "hybrid") {
			Switch($DefaultArchiOnx64) {
				# Lorsque la variable $DefaultArchiOnx64 est dfinie  '32 bits'
				{"32 bits"}{ 
					$Global:UninstallPath = $WindowsRegistryW6432node+$UninstallPathUni
					$Global:ProgramFiles = ${env:ProgramFiles(x86)}
                    If ($InstallParam -like "") {$Global:InstallDir = "$Global:ProgramFiles\$DefaultDestDir"}
				}
				# Lorsque la variable $DefaultArchiOnx64 est dfinie  '64 bits'
				{"64 bits"}{ 
					$Global:UninstallPath = $WindowsRegistry+$UninstallPathUni
					$Global:ProgramFiles = $env:ProgramW6432
                    If ($InstallParam -like "") {$Global:InstallDir = "$Global:ProgramFiles\$DefaultDestDir"}
				}
			}
		}
	}
	Else{Write-Log -Type "E" -Msg "RC:7023  - Il n'est pas possible de dtecter si le systme est 32 ou 64 bits" "7023"}
	If ($InstallParam -notlike ""){$Global:InstallDir = $InstallParam}
	
	If ($error){Write-Log -Type "E" -Msg "RC:7021  - $error" "7021"}
}


Function Del-Dependency {
<#****************************************************************************** 
	.DESCRIPTION 
		Dsinstallation d'une trousse dpendante  une trousse princiaple.

		Cette fonction peut-tre appele par le script de dsinstallation 
		de la trousse '.\include\Uninstall.ps1'
	.SWITCH DISPONIBLE
		-LogicielDep : Trousse dpendante  dsinstaller.
	.EXEMPLE
		Del-Dependency -LogicielDep "Microsoft Access" -> lors de l'appel de la dsinstallation d'Office
		
	.NOTES 
		Auteur: Marc-Andr Robitaille
******************************************************************************#> 
	Param(
	
	[String]$LogicielDep)

	$error.clear()
	$Operation = Registry-Operations -getvalue -localmachine -regkey "$UninstallPath$LogicielDep" -regvalue "UninstallString" -string 
	$Operation = $Operation.split([char]34) 
	$Operation = $Operation[1]
	Cmd-Exec -PathToExec "$env:Windir\system32\windowspowershell\v1.0\powershell.exe" `
			-ParamToPush "-file $guilmt$Operation$guilmt"
}

Function Pre-Requis{
<#****************************************************************************** 

	.DESCRIPTION 
		Gestion des pr-requis
		Cette fonction peut-tre appele par le script d'installation
		de la trousse '.\include\Install.ps1' permet de faire la gestion
		des pr-requis		
	.NOTES 
		Auteur: Marc-Andr Robitaille

******************************************************************************#> 

	$error.clear()

	$tableauPreRequis = @()
	if ($prerequis -ne "") {
		  ForEach ($logiciel in $prerequis) 
		  {
			If(!(Check-If-is-installed -program $logiciel -PresentOuiNon))
				{
					$tableauPreRequis += $logiciel
				}     
		  }
	}
      If ($tableauPreRequis)
      {
        write-host -ForegroundColor Yellow "Pr-requis manquant :"
        $tableauPreRequis|foreach{Write-Host -ForegroundColor Yellow $_.split("!")}
        Write-Log -Type "W" -Msg "Prrequis absent(s)"
      }
}

Function Del-Empty-Shortcut {
<#****************************************************************************** 
	.DESCRIPTION 
    
        Cette fonction s'assure qu'il ne restera pas de rpertoires vides
        dans "dmarrer\tous les programmes\..." suite  la dsinstallation
        d'une trousse.

		Cette fonction peut-tre appele par le script de d-installation 
			de la trousse '.\include\Uninstall.ps1'
	.SWITCH DISPONIBLE
		-path : Path du rpertoire en cours.
	.EXEMPLE
        Del-Empty-Shortcut -ShortcutParent "Exploitation\donnes"
	.NOTES 
		Auteur: Marc-Andr Robitaille
******************************************************************************#> 

	Param(
	[String]$ShortcutParent
	)
    #write-log -type "I" "Vrification du path $path"
           write-host $ShortcutParent
    #Vrification dans le menu "par Utilisateur"
    If(test-path "$PersUserMenu\$ShortcutParent")
	{
    	If (!(get-childitem "$PersUserMenu\$ShortcutParent")){
            Delete-File-Folder -RepToDelete "$PersUserMenu" -FilesToDelete "$ShortcutParent"
        }
    }
    
    #Vrification dans le menu "par All Users"
    If(test-path "$AllUserMenu\$ShortcutParent")
	{
    	If (!(get-childitem "$AllUserMenu\$ShortcutParent")){
            Delete-File-Folder -RepToDelete "$AllUserMenu" -FilesToDelete "$ShortcutParent" 
        }
    } 
    
    #Recherche du dernier index du caractre "\"
    $index = $ShortcutParent.lastindexof("\")
    #Recherche du nombre de caractre du path.
    $end = $ShortcutParent.length
   
    #s'il y a toujours des "\" dans le path, je recherche le prochain Index du caractre "\" et je supprime le reste de la chane
    #rappel de la fonction avec le nouveau $path 
    if(!($index -lt "0"))
    {
        $ShortcutParent = $ShortcutParent.remove($index,$end - $index)
        Del-Empty-Shortcut -ShortcutParent $ShortcutParent
    }
       
}

Function Manage-Shortcut{
<#****************************************************************************** 

	.DESCRIPTION 
		Gestion d'un raccourci
		Cette fonction peut-tre appele par le script d'installation
		de la trousse '.\include\Install.ps1' permet de faire la gestion
		d'un raccourci.
	.SWITCH DISPONIBLE
		-add  : Ajout d'un raccourci.
		-move : Dplacer un raccourci.
		-del  : Suppresion d'un raccourci.
	.EXEMPLE
		Manage-Shortcut -add  -path "c:\temp" -shortcut "test.lnk" -progexe "c:\test.exe"
		Manage-Shortcut -move -path "c:\temp" -shortcut "test.lnk" -destination "c:\temp\nouveau"
        Manage-Shortcut -copy -path "c:\temp" -shortcut "test.lnk" -destination "c:\temp\nouveau"
		Manage-Shortcut -del  -path "c:\temp" -shortcut "test.lnk"
		
	.NOTES 
		Auteur: Marc-Andr Robitaille

******************************************************************************#> 

	Param(

	[String]$path,
	[String]$shortcut,
	[String]$progexe,
	[String]$destination,
	[String]$domaine,
	[Switch]$add,
	[Switch]$del,
	[Switch]$move,
    [Switch]$copy
	)

	$error.clear()
	
	if ($add){
	
		Write-Log "I" "Vrification si le .exe cible existe."
		If (!(Test-Path $progexe)){
			write-log "E" "RC:7070 - Le .exe cible ne peut tre rejoint, fin de l'installation." "7070"
		}
		else{
		Write-Log "I" "Cration du raccourci $shortcut"
	
		Create-folder $path #vrification et cration du path de destination
	
		$WshShell = New-Object -comObject WScript.Shell
		$Shortcuts = $WshShell.CreateShortcut("$path\$shortcut")
		$Shortcuts.TargetPath = "$progexe"
		$Shortcuts.Description ="Cr par la trousse $strNOM_TROUSSE"
		$Shortcuts.WorkingDirectory ="%temp%"
		$Shortcuts.Save()
		}
	}
	
	if ($copy){
		Write-Log "I" "Copie du raccourci $shortcut"
		Create-folder $destination #vrification et cration du path de destination
		Copy-Files -sourceToCopy $path -FileToCopy $shortcut -CopyDestination $destination
	}
    if ($move){
        Write-Log "I" "Dplacement du raccourci $shortcut"
		Create-folder $destination #vrification et cration du path de destination
		Move-Item "$path\$shortcut" $destination
    }
	if ($del){
		
		Write-Log "I" "Suppression du raccourci $shortcut"
		Delete-File-Folder -RepToDelete $path -FilesToDelete $shortcut
	}
}

Function Acl-Modify-Users {
<#****************************************************************************** 
	.DESCRIPTION 
		Modification des droits ACL pour l'utilisateurs identifis sur un rpertoire.
		L'autorisation "Modify" sera appliqu au groupe utilisateurs identifis.
		Cette fonction pourra tre modifie pour ajouter plusieurs autorisations pour
		plusieurs groupes ainsi qu'une gestion de l'hritage.

		Cette fonction peut-tre appele par le script d'installation 
			de la trousse '.\include\Install.ps1'
	.SWITCH DISPONIBLE
		-FolderToChange : Rpertoire o la modification sera applique.
	.EXEMPLE
		Acl-Modify-Users -FolderToChange "$Installdir"
	.NOTES 
		Auteur: Marc-Andr Robitaille
		Trousse en dveloppement
******************************************************************************#> 
		param(
		[String]$FolderToChange
		)
		Write-Log "I" "Modification de la scurit NTFS pour le rperoire $FolderToChange."
		
		#obtenir les droit ntfs du rpertoire, exemple $FolderToChange = $installdir
		$acl = Get-Acl $FolderToChange
		#dfinition les rgles d'accs (garde l'hritage parents/enfants)
		$acl.setaccessruleprotection($true,$true)
		#cration de la rgle (mettre builtin\Utilisateurs authentifis  "modify")
		$regle = New-Object System.Security.AccessControl.FileSystemAccessRule("AUTORITE NT\Utilisateurs authentifis","Modify", "ContainerInherit, ObjectInherit", "None", "Allow")
		#ajouter la rgle
		$acl.addaccessrule($regle)
		#appliquer la scurit sur le rpertoire $FolderToChange
		$acl | Set-Acl $FolderToChange
		Write-Log "I" "Modification de la scurit NTFS pour le rperoire $FolderToChange complte."
}


Function Create-IISAppPools {
<#****************************************************************************** 
	.DESCRIPTION 
		Blah, Blah, Blah,...

		Cette fonction peut-tre appele par le script d'installation 
			de la trousse '.\include\Install.ps1'
	.SWITCH DISPONIBLE
		-AppPoolName : blah, blah, blah
	.EXEMPLE
		Create-IISAppPools -AppPoolName "IntRoot"
	.NOTES 
		Auteur: Simon Noiseux
******************************************************************************#> 
	param(
		[String]$AppPoolName
	)
	
	$error.Clear
	$ErrorActionPreference = "SilentlyContinue"
	
	Import-Module ServerManager
	Import-Module WebAdministration
	If (Get-Item "IIS:\AppPools\$AppPoolName"){
		Write-Log "W" "Le AppPools $AppPoolName est dj prsent sur ce serveur."
		$global:WarningExitCode = 6000
		Return $true
		}
	Write-Log "I" "Creation du AppPool $AppPoolName"
	New-Item "IIS:\AppPools\$AppPoolName" -Verbose:$false -OutVariable $output | Out-Null
}


Function Delete-IISAppPools {
<#****************************************************************************** 
	.DESCRIPTION 
		Blah, Blah, Blah,...

		Cette fonction peut-tre appele par le script d'installation 
			de la trousse '.\include\Install.ps1'
	.SWITCH DISPONIBLE
		-AppPoolName : blah, blah, blah
	.EXEMPLE
		Create-IISAppPools -AppPoolName "IntRoot"
	.NOTES 
		Auteur: Simon Noiseux
******************************************************************************#> 
	param(
		[String]$AppPoolName
	)
	
	$error.Clear
	$ErrorActionPreference = "SilentlyContinue"
	
	Import-Module ServerManager
	Import-Module WebAdministration
	
	If (Get-Item "IIS:\AppPools\$AppPoolName"){
		Write-Log "I" "Le AppPools $AppPoolName est prsent sur ce serveur."
		Remove-Item "IIS:\AppPools\$AppPoolName" -Verbose:$false -OutVariable $output -Force -Recurse | Out-Null
		Return $true
		}
	Write-Log "I" "Le AppPools $AppPoolName n'existe pas sur ce serveur."
}


Function Config-IISAppPools {
<#****************************************************************************** 
	.DESCRIPTION 
		Blah, Blah, Blah,...

		Cette fonction peut-tre appele par le script d'installation 
			de la trousse '.\include\Install.ps1'
	.SWITCH DISPONIBLE
		-PoolName 		: blah, blah, blah
		-Option2Modify	: 
		-Value2Apply 	: 	
	.EXEMPLE
		Create-IISAppPools -AppPoolName "IntRoot"
	.NOTES 
		Auteur: Simon Noiseux
******************************************************************************#> 
	param(
		[String]$PoolName,
		[String]$Option2Modify,
		[String]$Value2Apply
	)
	$error.Clear

	Import-Module ServerManager
	Import-Module WebAdministration
	
	Write-Log "I" "Configuration de l'option $Option2Modify du AppPool $PoolName"
	$ConfigPool = Get-Item "IIS:\AppPools\$PoolName"
	$i = 0
	$Option2Modify.split(".") | ForEach-Object {
		Set Option$i	$_
		$i += 1
		}
	
	Switch ($Option2Modify.Split(".").count){
			1		{$ConfigPool."$Option2Modify" = $Value2Apply}
			2		{$ConfigPool."$option0"."$option1" = $Value2Apply}
			3		{$ConfigPool."$option0"."$option1"."$option2" = $Value2Apply}
			4		{$ConfigPool."$option0"."$option1"."$option2"."$option3" = $Value2Apply}
		Default		{Write-Log "E" "Trop d'option ont t spcifies" "7099"}
	}
	$ConfigPool | Set-Item -Force -Verbose:$false -OutVariable $output | Out-Null
}

Function import-credentials {
<#****************************************************************************** 
	.DESCRIPTION 
		Rcupre un compte et son mot de passe prcdemment sauvegard par 
		export-credential
	
	.ENTREE
		-Credentiel = Compte  rcuprer en format Domaine\Usager
		-Fichier = Chemin complet du fichier texte contenant le compte 
		-Key = [optionel] cl d'encryption sous forme d'array de nombre. ce array
		doit tre le mme que celui utilis par exporte-credentiel.
		
	.SORTIE
		Objet de type credential
			
	.NOTES 
		Auteur: Simon Noiseux
******************************************************************************#> 
	param (
		[String]$Credential,
		[String]$Fichier
		)
	
	Write-log "I" "Importation du mot de passe pour le compte $Credential"
	$Credential = $Credential | ForEach {$_.Replace("\","\\")}
	$loccred =(select-string $Credential $Fichier -list).LineNumber
	$account = get-content $Fichier | where {$_.readcount -gt $loccred-1 -and $_.readcount -lt $loccred+2}

	$Cred = @{UserName=$account[0];Password=$account[1]}
	$secpwd = convertto-securestring $Cred.Password -AsPlainText -Force

	Return (new-object -TypeName system.management.automation.PSCredential -ArgumentList $Cred.UserName,$secpwd )
}


Function Discover-env {
<#****************************************************************************** 
	.DESCRIPTION 
		Cette fonction dfinie la variable "$strPALIER" en fonction des diffrents
		domaines et palliers de la DSQ.

		Cette fonction peut-tre appele par le script d'installation 
			de la trousse '.\include\Install.ps1'
	.SWITCH DISPONIBLE
		Aucune
	.EXEMPLE
		Discover-env
	.NOTES 
		Auteur: Simon Noiseux
		Modification : Mathieu Fairservice
******************************************************************************#> 
	$strTRONCON_1 = $strComputerName -Replace("^.\d*","")
	$strLETTRE_ENVIR  = $strTRONCON_1 -Replace("\d*.$","")
	Write-log "I" "Dcouverte du pallier dans lequel ce serveur est install"
    Switch -wildcard ($strDOMAIN){
		"WORKGROUP" {$global:strPALIER = "WORKGROUP"
					Write-log "I" "Ce serveur est dans un WORKGROUP"
					}			
		# "ADTECNO3*" {$global:strPALIER = "tecno3"
					# Write-log "I" "Ce serveur est dans le domaine ADTECNO3"
					# }
		"ADTECNO2*" {$global:strPALIER = "tecno2"
					Write-log "I" "Ce serveur est dans le domaine ADTECNO2"
					}
		# "ADTECHNO*" {$global:strPALIER = "tecno"
					# Write-log "I" "Ce serveur est dans le domaine ADTECHNO"
					# }
		"ADPREDEV*" {$global:strPALIER = "prdev"
					Write-log "I" "Ce serveur est dans le domaine ADPREDEV"
					}
		"ADPROD*"      {
				Write-log "I" "Ce serveur est dans le domaine ADPROD"
				switch ( $strLETTRE_ENVIR ){
				"U" {$global:strPALIER = "unit"
					Write-log "I" "Ce serveur est dans le palier UNITAIRE"
					}
				"C" {$global:strPALIER = "fonct"
					Write-log "I" "Ce serveur est dans le palier FONCTIONNEL"
					}
				"I" {$global:strPALIER = "integ"
					Write-log "I" "Ce serveur est dans le palier INTGR"
					}
				"A" {$global:strPALIER = "acptn"
					Write-log "I" "Ce serveur est dans le palier d'ACCEPTATION"
					}
				"F" {$global:strPALIER = "forma"
					Write-log "I" "Ce serveur est dans le palier de FORMATION"
					}
				"R" {$global:strPALIER = "parte"
					Write-log "I" "Ce serveur est dans le palier PARTENAIRE"
					}
				"G" {$global:strPALIER = "urg"  
					Write-log "I" "Ce serveur est dans le palier d'URGENCE"
					}
				"P" {$global:strPALIER = "prod" 
					Write-log "I" "Ce serveur est dans le palier de PROD"
					}
				"Q" {$global:strPALIER = "partq" 
					Write-log "I" "Ce serveur est dans le palier de Partenaire 2 (ITEC)"
					}
				"H" {$global:strPALIER = "pprd" 
					Write-log "I" "Ce serveur est dans le palier de Pr-Production (DSQ)"
					}	
				"S" {$global:strPALIER = "asmg" 
					Write-log "I" "Ce serveur est dans le palier de Assemblage2 (ITEC)"
					}	
				"M" {$global:strPALIER = "maint" 
					Write-log "I" "Ce serveur est dans le palier de Maintenance (ITEC)"
					}
				"B" {$global:strPALIER = "foncB" 
					Write-log "I" "Ce serveur est dans le palier de Pr-Production (DSQ)"
					}	
				"O" {$global:strPALIER = "prprd" 
					Write-log "I" "Ce serveur est dans le palier de Pr-Production (DSQ)"
					}	
				"D" {$global:strPALIER = "devl" 
					Write-log "I" "Ce serveur est dans le palier de dveloppement"
					}
				Default {$global:strPALIER = "autre" 
					Write-log "I" "Impossible de dterminer le palier du serveur."}	
				}
		}
		Default	{
			Write-Log "W" "Impossible de dterminer l'environnement du serveur."
			Write-Log "W" "La variable d'identification du palier ne sera pas dfinie."
			$global:WarningExitCode = 6000
		}
	}
	#If ($strPALIER -eq $null) {Write-log "E" "Le gabarit n'a pas russi  dterminer le palier d'excution" "7099"}
}

Function Detecte-Redemarrage-Requis{
<#****************************************************************************** 
	.DESCRIPTION 
		Identifier si un redemarrage est toujours en attente. 
		
		Cette fonction peut-tre appele par '.\include\ScriptInstall' 
	
	.ENTREE
		Appel de la fonction
		
	.SORTIE
		Sans argument : Retourne un $TRUE : La trousse s'installe et affiche l'information  l'installateur.	
        Avec -Abort : Empche la trousse de s'installer et affiche un "Error"  l'installateur.
		
	.EXEMPLE
		Detecte_Redemarrage_Requis
        Detecte_Redemarrage_Requis -Requis
		
	.NOTES 
		Auteur: Simon Noiseux
        Modification : Marc-Andr Robitaille
            - Aot 2013: Ajout de l'argument -Abort.
             
******************************************************************************#> 

    param (
            [Switch]$Abort
          )
    
        write-log "I" "Controle si un redemarrage est en attente"
  $SessionManagerKEY = Registry-operations -GetValue -LocalMachine `
   -RegKey "SYSTEM\CurrentControlSet\Control\Session Manager" -MultiString -RegValue "PendingFileRenameOperations"
  
  $WindowsUpdateKEY = Registry-operations -GetKey -LocalMachine `
   -RegKey "SOFTWARE\Microsoft\Windows\CurrentVersion\WindowsUpdate\Auto Update\RebootRequired"
            
        If ($SessionManagerKEY -ne $null -or $WindowsUpdateKEY)
        {
            If($Abort)
            {
            #Si le paramtre Abort est utilis, le message sera affich en erreur dans le log et la trousse s'arrtera !
            write-log "E" "RC:7020 - Un redemarrage est ncessaire avant de lancer l'installation de cette trousse." "7020"
            } 
            else
            {
            #Si les cls de registres sont dtectes mais non critiques, le message sera tout simplement inscrit dans le log sans erreur.
            write-log "I" "Un redemarrage du systme est en attente."
            }
        } else
			{
			Write-Log "I" "Aucun redmarrage n'est en attente."
			}
}

Function Manage-App-V {
<#****************************************************************************** 
	.DESCRIPTION 
		Cette fonction permet de faire la gestion d'une trousse App-V. 
		
		Cette fonction peut-tre appele par le script d'installation 
		de la trousse '.\include\Install.ps1' 
	
	.SWITCH DISPONIBLE
		Install : Permet de faire l'installation d'une trousse App-V
		Uninstall : Permet de faire la dsinstallation d'une trousse App-V
		
	.NOTES 
		Auteur: Marc-Andr Robitaille / Mathieu Roy
******************************************************************************#> 

	param (
		[Switch]$Install,
		[Switch]$Uninstall
		)
					
		$strManifestXML = "$strNOM_TROUSSE" + "_manifest.xml"

		if($Install)
		{
        #L'agent App-V doit tre install sur le poste pour faire une installation de trousse App-V.
		Check-If-is-installed -Program "!App-v_desktop*" -requis # vrifier si changement de nom.
        
		#Installation du produit	
		if($strREP_SCRIPT.startswith("\\")) # Path rseaux
        {
			CMD-Exec -PathToExec "$InstallDir\sftmime.exe" `
	    		-ParamToPush "ADD PACKAGE:$strNOM_TROUSSE /MANIFEST \$strREP_SCRIPT\Sources\$strManifestXML"
		}
        else 
        {
        	CMD-Exec -PathToExec "$InstallDir\sftmime.exe" `
	    		-ParamToPush "ADD PACKAGE:$strNOM_TROUSSE /MANIFEST $strREP_SCRIPT\Sources\$strManifestXML"
        }
			
		#Cration du rpertoire \ParamTrousses\NomTrousse sinon la copie du sft tombe en erreur.
			If (!(Test-Path "$DefaultProgramsDir$RepDestCfgFiles")){
				Create-Folder "$DefaultProgramsDir$RepDestCfgFiles"
				Start-Sleep -s 1
			}
			
			write-log "I" "Copie du plus rcent fichier .SFT dans ParamTrousses\$strNOM_TROUSSE"
 			Get-ChildItem "$strREP_SCRIPT\Sources\*.sft" | sort LastWriteTime -desc | select -first 1 | Copy-Item -dest "$DefaultProgramsDir$RepDestCfgFiles"		
		}
		
		elseif($Uninstall){
			CMD-Exec -PathToExec "$InstallDir\sftmime.exe" `
		    	-ParamToPush "DELETE PACKAGE:$guilmt$strNOM_TROUSSE$guilmt"
			#Reset de la cache du client App-V (prend effet seulement lors du prochain reboot)
			If ($OSArchitecture -eq "64 bits") {
				write-log -Type "I" -Msg "Reset de la cache App-V pour poste 64 bits"
				Registry-operations -SetValue -LocalMachine -RegKey "SOFTWARE\Wow6432Node\Microsoft\SoftGrid\4.5\Client\AppFS" `
				-DWORD -RegValue "State" -NewRegValueProperties "00000000"
			}
			ElseIf ($OSArchitecture -eq "32 bits") {
				write-log -Type "I" -Msg "Reset de la cache App-V pour poste 32 bits"
				Registry-operations -SetValue -LocalMachine -RegKey "SOFTWARE\Microsoft\SoftGrid\4.5\Client\AppFS" `
				-DWORD -RegValue "State" -NewRegValueProperties "00000000"
			}
			Else{Write-Log -Type "E" -Msg "RC:7023  - Il n'est pas possible de dtecter si le systme est 32 ou 64 bits" "7023"}
		}
	
}
