<#******************************************************************************
* **************************************************************************** *
* *                                                                          * *
* *		.DESCRIPTION :                                                       * *
* *			Ce fichier contient toutes les variables et constantes 			 * *
* *			globales disponibles lors de l'excution du fichier 			 * *
* *			principal 'installation.ps1'                                     * *
* *                                                                          * *
* *			Si vous dsirez ajouter un arguments pour l'installation de      * *
* * 		votre trousse (ex: capture de l'ID et mot de passe d'un      	 * *
* *			utilisateur) vous devez l'ajouter dans ce script. Lorsque 		 * *
* *			vous ajouter un arguments vous devez galement ajuster la 		 * *
* *			section 'Help' de ce script, afin d'aider les utilisateur 	 	 * *
* *			de votre trousse.	                                         	 * *
* *                                                                          * *
* *		.UTILISATION:                                                        * *
* *			Vous pouvez modifier ce script afin de faire l'installation      * *
* *			de votre logiciel. Toutefois, sa modification n'est pas      	 * *
* *			obligatoire.                                                 	 * *
* *                                                                          * *
* *			Ce fichier ne peut tre lanc seul. Il est appel par            * *
* *			'installation.ps1' lors de son excution.                    	 * *
* *                                                                          * *
* *		.AUTHEURS :                                                          * *
* *			NOM : Dany Fournier        DATE : Fvrier 2011                   * *
* *			NOM : Simon Noiseux        DATE : Mars & Avril 2011              * *
* *                                                                          * *
* *		.MODIFICATIONS :                                                     * *
* *			NOM :                      DATE :                                * *
* *			DESCRITION :                                                     * *
* *				...                                                          * *
* *																			 * *
* *		.VERSION :															 * *
* *			Gabarit V07						DATE : Novembre 2013			 * *
* *                                                                          * *
* **************************************************************************** *
******************************************************************************#>

<#******************************************************************************
                 Affiche les commandes de la trousse                    	   *
******************************************************************************#>
	# Lorsque vous ajoutez un argument, vous devez le documenter dans cette section
	If ($help){
		cls
		Write-Host " "
		Write-Host "Syntaxe d'utilisation du script"
		Write-Host "Exemple : $ScriptName -p1 123 -p2 abc -user toto"
		Write-Host " "
		Write-Host "	[InstallDir]	= Rpertoire d'installation"		
		Write-Host "	[Force]			= Force l'installation"
		Write-Host "	[help] 			= Affiche l'aide"
		Write-Host "	[Fonctions] 	= Affiche toutes les fonctions"
		Write-Host "	[Verbose] 		= Affiche tous les commentaires d'installation"
		Write-Host "	[Install] 		= Installe l'application de la trousse"
		Write-Host "	[Config] 		= Applique les configuration du logiciel inclu dans la trousse"
		Break
	}


#*******************************************************************************
#                      Affiche les fonctions de la trousse                     *
#*******************************************************************************
	If ($Fonctions){
		cls
		Write-Host "Voici la liste des fonctions disponibles" -ForegroundColor "red"
		Write-Host "***************************************"
		#Lecture du fichier 'Lib.ps1'
		Get-Content "$strREP_SCRIPT\include\Lib.ps1" | 
			# Tri du fichier en ordre alphabtique
			Sort-Object | Foreach-Object {$_} {
				# Filtre des lignes commencant par 'Function'
				If ($_.StartsWith("Function")){
					$a = $_ -Replace ("Function ", "Fonction : ")
					$a = $a -replace ('{',"") 
					"  $a"
				}
			} 
		Write-Host "***************************************"
		Break
	}	

	
#----- PREPARATION DE L'AFFICHAGE DES ARGS -----#
$Argments = "InstallDir=$InstallDir","Install = $install","Config = $config"
#	$Argments = "P1=$P1","P2=$P2","InstallDir=$InstallDir","User=$User","Pwd=$Pwd"	


#*******************************************************************************
#                          EXEMPLES d'arguments                                *
#*******************************************************************************
#	#----- SAISIE DE L'IDENTIFIANT ET DU MOT DE PASSE EN MODE GRAPHIQUE -----#
#	If (($user -eq "") -or ($pwd -eq "")){
#    	$Cred = $Host.ui.PromptForCredential("","Enter an account to add the `
#			machine to the domain","$env:userdomain\$env:username","")
#    	If ($Cred -eq $null){
#        	Write-Host "L'identifiant et le mot de passe sont obligatoires"
#        	exit
#    	}Else{
#    		$user = $Cred.GetNetworkCredential().UserName
#    		$pwd = $Cred.Password
#    	}
#    }Else{
#    	If ($user -eq ""){$user = $(Read-Host -prompt "Entrer le nom de l'utilisateur")}
#    	If ($pwd -eq ""){
#    		$pwd = Read-Host 'Entrer le mot de passe' -AsSecureString
#    	}Else{
#    		$pwd = ConvertTo-SecureString $pwd -force -asPlainText
#    	}
#    }
#
#	#----- # SAISIE D'UN PARAMTRE OBLIGATOIRE -----#
#	If($P1 -eq ""){
#		[void][System.Reflection.Assembly]::LoadWithPartialName('Microsoft.VisualBasic')  
#		$P1 = [Microsoft.VisualBasic.Interaction]::InputBox('Entrer la valeur de `
#			$P1', "Paramtre manquant", "default")
#		If($P1 -eq ""){
#		    Write-Host "Le paramtre P1 est obligatoire."
#       		exit	
#		}
#	}